/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuEnergyConnector;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.TileEntityEnergyConnector;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;

public class ScreenEnergyConnector
extends ScreenFluid {
    public Player player;
    public TileEntityEnergyConnector tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenEnergyConnector(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuEnergyConnector(inv, (TileEntityFluidItemContainer)tile));
        this.ySize = 192;
        this.tile = (TileEntityEnergyConnector)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        TileEntityTieredMachineBase tile;
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_energy_connector.png");
        switch (this.tile.tier) {
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_energy_connector.png");
                break;
            }
            case REINFORCED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_energy_connector.png");
                break;
            }
            case AWAKENED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/awakened_energy_connector.png");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.connectedTo instanceof TileEntityTieredMachineBase && (tile = (TileEntityTieredMachineBase)this.tile.connectedTo).isBurning()) {
            int counter = tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 80, y + 17 + 12 - counter, 176, 44 - counter, 14, counter + 2);
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 80, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 60, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        super.buttonClicked(button);
    }
}

