/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuFilter;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageFilterConfig;
import sunsetsatellite.signalindustries.tiles.TileEntityFilter;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenFilter
extends ScreenFluid {
    public Player player;
    public TileEntityFilter tile;
    public ButtonElement defaultSide;
    public ButtonElement ignoreMeta;

    public ScreenFilter(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuFilter(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityFilter)tile;
        this.player = inv.player;
        this.ySize = 233;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/filter.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = 0x404040;
        String s = I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey());
        int stringWidth = this.font.getStringWidth(s);
        this.font.drawString(s, 90 - stringWidth / 2, 6, color);
    }

    public void init() {
        int w = (this.width - this.xSize) / 2;
        int h = (this.height - this.ySize) / 2;
        ButtonElement defaultSide = new ButtonElement(0, w + 8 + 22, h + 128, 120, 20, "Default: " + (this.tile.defaultSide.ordinal() + 1) + " (" + this.tile.defaultSide.name() + ")");
        this.buttons.add(defaultSide);
        ButtonElement ignoreMeta = new ButtonElement(1, w + 8, h + 128, 20, 20, this.tile.ignoreMeta ? "!M" : "M");
        this.buttons.add(ignoreMeta);
        this.ignoreMeta = ignoreMeta;
        this.defaultSide = defaultSide;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.defaultSide) {
            int ord = this.tile.defaultSide.ordinal();
            if (ord++ >= TileEntityFilter.FilterSide.values().length - 1) {
                ord = 0;
            }
            this.tile.defaultSide = TileEntityFilter.FilterSide.values()[ord];
            button.displayString = "Default: " + (ord + 1) + " (" + this.tile.defaultSide.name() + ")";
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageFilterConfig(this.tile.getPosition(), ((Object)((Object)this.tile)).getClass(), this.tile.defaultSide, this.tile.ignoreMeta));
            }
        } else if (button == this.ignoreMeta) {
            this.tile.ignoreMeta = !this.tile.ignoreMeta;
            String string = button.displayString = this.tile.ignoreMeta ? "!M" : "M";
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageFilterConfig(this.tile.getPosition(), ((Object)((Object)this.tile)).getClass(), this.tile.defaultSide, this.tile.ignoreMeta));
            }
        }
        super.buttonClicked(button);
    }
}

