/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuInjector;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityEnergyInjector;

public class ScreenInjector
extends ScreenFluid {
    public Player player;
    public TileEntityEnergyInjector tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenInjector(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuInjector(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityEnergyInjector)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/energy_injector_basic.png");
        switch (this.tile.tier) {
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/energy_injector_basic.png");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            this.drawTexturedModalRect(x + 80, y + 36, 176, 0, 14, 14);
        }
        if (this.tile.speedMultiplier > 1.0f) {
            this.drawStringCentered(this.font, this.tile.speedMultiplier + "x", x + this.xSize - 16, y + this.ySize / 2 - 16, this.tile.speedMultiplier >= 3.0f ? -23296 : (this.tile.speedMultiplier >= 2.0f ? -65281 : -32640));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 80, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 60, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        super.buttonClicked(button);
    }
}

