/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageIOChange;
import sunsetsatellite.signalindustries.util.IOPreview;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenItemIOConfig
extends Screen {
    public Screen parentScreen;
    public Player entityplayer;
    public TileEntityFluidItemContainer tile;
    public int xSize = 176;
    public int ySize = 166;
    public MenuAbstract inventorySlots;

    public ScreenItemIOConfig(Player player, MenuAbstract menu, Screen parent, TileEntityFluidItemContainer tile) {
        super(parent);
        this.parentScreen = parent;
        this.entityplayer = player;
        this.tile = tile;
        this.inventorySlots = menu;
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(partialTick);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.enableInventoryLight();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mx, my, partialTick);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    public void init() {
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 63, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.Y_POS)).getLetter()));
        this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 48, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.Z_POS)).getLetter()));
        this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 33, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.Y_NEG)).getLetter()));
        this.buttons.add(new ButtonElement(0, Math.round((float)this.width / 2.0f) + 4, Math.round((float)this.height / 2.0f) - 48, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.X_POS)).getLetter()));
        this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f) - 24, Math.round((float)this.height / 2.0f) - 48, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.X_NEG)).getLetter()));
        this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f) + 4, Math.round((float)this.height / 2.0f) - 33, 15, 15, ((Connection)this.tile.itemConnections.get(Direction.Z_NEG)).getLetter()));
        this.buttons.add(new ButtonElement(8, Math.round((float)this.width / 2.0f) - 10 + 50, Math.round((float)this.height / 2.0f) - 63, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.Y_POS) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.Y_POS))));
        this.buttons.add(new ButtonElement(10, Math.round((float)this.width / 2.0f) - 10 + 50, Math.round((float)this.height / 2.0f) - 48, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.Z_POS) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.Z_POS))));
        this.buttons.add(new ButtonElement(9, Math.round((float)this.width / 2.0f) - 10 + 50, Math.round((float)this.height / 2.0f) - 33, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.Y_NEG) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.Y_NEG))));
        this.buttons.add(new ButtonElement(6, Math.round((float)this.width / 2.0f) + 4 + 50, Math.round((float)this.height / 2.0f) - 48, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.X_POS) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.X_POS))));
        this.buttons.add(new ButtonElement(7, Math.round((float)this.width / 2.0f) - 24 + 50, Math.round((float)this.height / 2.0f) - 48, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.X_NEG) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.X_NEG))));
        this.buttons.add(new ButtonElement(11, Math.round((float)this.width / 2.0f) + 4 + 50, Math.round((float)this.height / 2.0f) - 33, 15, 15, (Integer)this.tile.activeItemSlots.get(Direction.Z_NEG) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(Direction.Z_NEG))));
        this.buttons.add(new ButtonElement(12, this.width / 2 - 85, this.height / 2 - 12, 30, 15, "All I"));
        this.buttons.add(new ButtonElement(13, this.width / 2 - 55, this.height / 2 - 12, 30, 15, "All O"));
        if (this.tile instanceof IHasIOPreview) {
            this.buttons.add(new ButtonElement(14, this.width / 2 + 60, this.height / 2 - 75, 20, 20, "P"));
        }
        if (this.tile.getContainerSize() == 1) {
            ((ButtonElement)this.buttons.get((int)6)).enabled = false;
            ((ButtonElement)this.buttons.get((int)7)).enabled = false;
            ((ButtonElement)this.buttons.get((int)8)).enabled = false;
            ((ButtonElement)this.buttons.get((int)9)).enabled = false;
            ((ButtonElement)this.buttons.get((int)10)).enabled = false;
            ((ButtonElement)this.buttons.get((int)11)).enabled = false;
        }
        super.init();
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == 1) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (buttonNum == 1) {
            for (ButtonElement button : this.buttons) {
                if (!button.mouseClicked(this.mc, mx, my)) continue;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.buttonClickedAlt(button);
            }
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (this.tile != null) {
            Object dir;
            int currentButtonId = -1;
            if (button.id >= 0 && button.id <= 5) {
                dir = Direction.values()[button.id];
                this.tile.cycleItemIOForSide((Direction)dir);
                button.displayString = ((Connection)this.tile.itemConnections.get(dir)).getLetter();
                currentButtonId = button.id;
            }
            if (button.id > 5 && button.id < 12) {
                dir = Direction.values()[button.id - 6];
                this.tile.cycleActiveItemSlotForSide((Direction)dir, false);
                button.displayString = String.valueOf(this.tile.activeItemSlots.get(dir));
                currentButtonId = button.id;
            }
            if (button.id == 12) {
                for (Object direction : Direction.values()) {
                    this.tile.itemConnections.replace(direction, Connection.INPUT);
                }
                for (ButtonElement b : this.buttons) {
                    if (b.id < 0 || b.id >= 6) continue;
                    b.displayString = ((Connection)this.tile.itemConnections.get(Direction.values()[b.id])).getLetter();
                }
                currentButtonId = button.id;
            }
            if (button.id == 13) {
                for (Object direction : Direction.values()) {
                    this.tile.itemConnections.replace(direction, Connection.OUTPUT);
                }
                for (ButtonElement b : this.buttons) {
                    if (b.id < 0 || b.id >= 6) continue;
                    b.displayString = ((Connection)this.tile.itemConnections.get(Direction.values()[b.id])).getLetter();
                }
                currentButtonId = button.id;
            }
            if (button.id == 14 && this.tile instanceof IHasIOPreview) {
                Direction[] p = (Direction[])this.tile;
                p.setPreview(((IHasIOPreview)this.tile).getPreview() != IOPreview.ITEM ? IOPreview.ITEM : IOPreview.NONE);
            }
            if (EnvironmentHelper.isClientWorld() && currentButtonId != -1) {
                if (currentButtonId == 12 || currentButtonId == 13) {
                    for (Direction dir2 : Direction.values()) {
                        Vec3i position = this.tile.getPosition();
                        Connection connection = (Connection)this.tile.itemConnections.get(dir2);
                        int slot = (Integer)this.tile.activeItemSlots.get(dir2);
                        NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageIOChange(position, connection, dir2, IOPreview.ITEM, slot, this.tile.getClass()));
                    }
                } else {
                    dir = Direction.Y_POS;
                    if (currentButtonId <= 5 && currentButtonId >= 0) {
                        dir = Direction.values()[currentButtonId];
                    } else if (currentButtonId > 5 && currentButtonId < 12) {
                        dir = Direction.values()[currentButtonId - 6];
                    }
                    Vec3i position = this.tile.getPosition();
                    Connection connection = (Connection)this.tile.itemConnections.get(dir);
                    int slot = (Integer)this.tile.activeItemSlots.get(dir);
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageIOChange(position, connection, (Direction)dir, IOPreview.ITEM, slot, this.tile.getClass()));
                }
            }
        }
        super.buttonClicked(button);
    }

    protected void buttonClickedAlt(ButtonElement button) {
        if (button.id > 5 && button.id < 12) {
            Direction dir = Direction.values()[button.id - 6];
            this.tile.cycleActiveItemSlotForSide(dir, true);
            String string = button.displayString = (Integer)this.tile.activeItemSlots.get(dir) == -1 ? "*" : String.valueOf(this.tile.activeItemSlots.get(dir));
            if (EnvironmentHelper.isClientWorld()) {
                Vec3i position = this.tile.getPosition();
                Connection connection = (Connection)this.tile.itemConnections.get(dir);
                int slot = (Integer)this.tile.activeItemSlots.get(dir);
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageIOChange(position, connection, dir, IOPreview.ITEM, slot, this.tile.getClass()));
            }
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Items", 45, 6, -12566464);
        this.font.drawString("I/O", 78, 70, -12566464);
        this.font.drawString("Slot", 128, 70, -12566464);
        this.font.drawString("Y+", 26, 22, -1);
        this.font.drawString("Y-", 26, 58, -1);
        this.font.drawString("Z+", 26, 40, -1);
        this.font.drawString("X+", 44, 40, -1);
        this.font.drawString("Z-", 44, 58, -1);
        this.font.drawString("X-", 8, 40, -1);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/ioconfig.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }
}

