/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import java.util.Objects;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.signalindustries.items.tools.ItemPulsar;
import sunsetsatellite.signalindustries.menus.MenuPulsar;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import sunsetsatellite.signalindustries.util.Tier;

public class ScreenPulsar
extends ScreenFluid {
    public int pulsarSlotIndex;
    public boolean isArmor;
    public ItemStack pulsar;
    public Player player;

    public ScreenPulsar(ContainerInventory inventoryPlayer, int pulsarSlotIndex, boolean isArmor) {
        super((MenuFluid)new MenuPulsar(inventoryPlayer, pulsarSlotIndex, isArmor));
        this.pulsarSlotIndex = pulsarSlotIndex;
        this.isArmor = isArmor;
        this.player = inventoryPlayer.player;
        this.pulsar = inventoryPlayer.getItem(pulsarSlotIndex);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/pulsar_ui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        String name = "";
        if (this.pulsar.getItem() instanceof ItemPulsar) {
            name = I18n.getInstance().translateNameKey(this.fluidSlots.itemInventory.getNameTranslationKey());
            if (Objects.requireNonNull(((ItemPulsar)this.pulsar.getItem()).tier) == Tier.REINFORCED) {
                color = -65536;
            }
            this.font.drawCenteredString(name, 90, 6, color);
        }
    }

    public void removed() {
        super.removed();
        this.pulsar = this.player.inventory.getItem(this.pulsarSlotIndex);
        InventorySerializer.saveInvToNBT(this.pulsar, this.fluidSlots.itemInventory);
    }
}

