/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageReactorStart;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntitySignalumReactor;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenSignalumReactor
extends Screen {
    public TileEntitySignalumReactor tile;
    public Player player;
    public int xSize = 256;
    public int ySize = 166;
    TooltipElement tooltip;

    public ScreenSignalumReactor(ContainerInventory inventory, TileEntity tile) {
        this.tile = (TileEntitySignalumReactor)tile;
        this.player = inventory.player;
        this.tooltip = new TooltipElement(Minecraft.getMinecraft());
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(partialTick);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mx, my, partialTick);
    }

    private void drawGuiContainerForegroundLayer() {
        this.font.drawCenteredString(I18n.getInstance().translateNameKey("container.signalindustries.reactor"), 128, 6, -65536);
        float capacity = (float)(this.tile.getFuel() + this.tile.getDepletedFuel()) / 36000.0f * 100.0f;
        float fill = 100.0f - (float)this.tile.getDepletedFuel() / (float)(this.tile.getFuel() + this.tile.getDepletedFuel()) * 100.0f;
        if (Float.isNaN(fill)) {
            fill = 0.0f;
        }
        int color = 0xFFFFFFF;
        switch (this.tile.state) {
            case INACTIVE: {
                color = -12566464;
                break;
            }
            case IGNITING: {
                color = Short.MIN_VALUE;
                break;
            }
            case RUNNING: {
                color = -16711936;
            }
        }
        this.font.drawCenteredString(String.format("%.0f%%", Float.valueOf(fill)), 128, 63, -1);
        this.font.drawCenteredString(String.valueOf((Object)this.tile.state), 128, 77, color);
        this.font.drawCenteredString(String.format("%.0f%%", Float.valueOf(capacity)), 128, 90, -8355712);
    }

    private void drawGuiContainerBackgroundLayer(float partialTick) {
        @NotNull Texture tex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/signalum_reactor_ui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(tex);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        int h = (this.tile.getFuel() + this.tile.getDepletedFuel()) * 64 / 36000;
        int depletedH = (int)((float)(this.tile.getDepletedFuel() * h) / (this.tile.getFuel() + this.tile.getDepletedFuel() == 0 ? Float.MIN_VALUE : (float)(this.tile.getFuel() + this.tile.getDepletedFuel())));
        this.drawTexturedModalRect(x + 96, y + 50 + (64 - h), 0, 166 + (64 - h), 64, h);
        this.drawTexturedModalRect(x + 96, y + 50 + (64 - depletedH), 64, 166 + (64 - depletedH), 64, depletedH);
    }

    public void tick() {
        super.tick();
        if (!this.mc.thePlayer.isAlive() || this.mc.thePlayer.removed) {
            this.mc.thePlayer.closeScreen();
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (button.id == 0) {
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageReactorStart(this.tile.getPosition(), this.tile.getClass()));
            }
            this.tile.start();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        this.buttons.add(new ButtonElement(0, Math.round((float)this.width / 2.0f) - 30, Math.round((float)this.height / 2.0f) + 50, 60, 20, "ON/OFF"));
        super.init();
    }
}

