/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.multiblocks.Multiblock;

public class MultiblockMaterialsPage
extends GuidebookPage {
    public final Multiblock multiblock;
    private final TooltipElement guiTooltip;
    private final ItemElement guiRenderItem;
    private static final Minecraft mc = Minecraft.getMinecraft();
    public List<SlotGuidebook> slots = new ArrayList<SlotGuidebook>();
    private static long ticks = 0L;

    public MultiblockMaterialsPage(GuidebookSection section, Multiblock multiblock) {
        super(section);
        this.multiblock = multiblock;
        this.guiTooltip = new TooltipElement(mc);
        this.guiRenderItem = new ItemElement(mc);
        List blocksUncondensed = multiblock.getBlocks().stream().map(B -> new ItemStack(B.block, 1, B.meta == -1 ? 0 : B.meta)).collect(Collectors.toList());
        ArrayList blocks = Catalyst.condenseItemList(blocksUncondensed);
        ItemStack origin = new ItemStack(multiblock.getOrigin().block, 1, multiblock.getOrigin().meta == -1 ? 0 : multiblock.getOrigin().meta);
        boolean matched = false;
        for (ItemStack is : blocks) {
            if (!origin.isItemEqual(is)) continue;
            ++is.stackSize;
            matched = true;
            break;
        }
        if (!matched) {
            blocks.add(origin);
        }
        int i = 0;
        int maxSlotsInRow = 7;
        for (ItemStack block : blocks) {
            this.slots.add(new SlotGuidebook(i, 18 + 18 * (i % maxSlotsInRow), 24 + 18 * (i / maxSlotsInRow), new RecipeSymbol(block), false, null));
            ++i;
        }
    }

    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.multiblock != null) {
            this.drawStringCenteredNoShadow(fr, I18n.getInstance().translateNameKey(this.multiblock.translateKey), x + 79, y + 10, 0);
        } else {
            this.drawStringCenteredNoShadow(fr, "No results :(", x + 79, y + 110, -8355712);
        }
        SlotGuidebook mouseOverSlot = null;
        ++ticks;
        for (SlotGuidebook slot : this.slots) {
            if (ticks > 100L) {
                slot.showRandomItem();
                if (this.slots.get(this.slots.size() - 1) == slot) {
                    ticks = 0L;
                }
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            if (slot.item != null && slot.item.itemID < 16384 && (Blocks.getBlock((int)slot.item.itemID) == Blocks.FLUID_WATER_FLOWING || Blocks.getBlock((int)slot.item.itemID) == Blocks.FLUID_WATER_STILL) && ((Boolean)MultiblockMaterialsPage.mc.gameSettings.biomeWater.value).booleanValue()) {
                BlockModel blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)Blocks.getBlock((int)slot.item.itemID));
                ItemModel itemModel = (ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)slot.getItemStack().getItem());
                int waterColor = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)Blocks.FLUID_WATER_FLOWING)).getWorldColor((WorldSource)MultiblockMaterialsPage.mc.currentWorld, (int)MultiblockMaterialsPage.mc.thePlayer.x, (int)MultiblockMaterialsPage.mc.thePlayer.y, (int)MultiblockMaterialsPage.mc.thePlayer.z);
                Color c = new Color().setARGB(waterColor);
                c.setRGBA(c.getRed(), c.getGreen(), c.getBlue(), 64);
                ((IColorOverride)blockModel).overrideColor((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue(), (float)c.getAlpha());
                this.guiRenderItem.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
                ((IColorOverride)blockModel).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
                continue;
            }
            this.guiRenderItem.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (MultiblockMaterialsPage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (MultiblockMaterialsPage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }

    protected void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL);
            String str = this.guiTooltip.getTooltipText(mouseOverSlot.getItemStack(), showDescription, (Slot)mouseOverSlot);
            if (str.isEmpty()) continue;
            this.guiTooltip.render(str, mouseX, mouseY, 8, -8);
        }
    }
}

