/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidPipe;
import sunsetsatellite.catalyst.multipart.api.ISupportsMultiparts;
import sunsetsatellite.catalyst.multipart.api.Multipart;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.ITiered;

public class TileEntityConduit
extends TileEntityFluidPipe
implements ISupportsMultiparts {
    public final HashMap<Direction, Multipart> parts = (HashMap)Catalyst.mapOf((Object[])Direction.values(), (Object[])new Multipart[Direction.values().length]);

    public TileEntityConduit() {
        ((ArrayList)this.acceptedFluids.get(0)).clear();
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
    }

    public void tick() {
        ITiered tiered;
        if (this.fluidContents[0] != null && this.fluidContents[0].amount < 0) {
            this.fluidContents[0] = null;
        }
        if ((tiered = (ITiered)Catalyst.blockLogic((Block)this.getBlock(), ITiered.class)) != null) {
            this.fluidCapacity[0] = (int)Math.pow(2.0, tiered.getTier().ordinal()) * 1000;
            this.transferSpeed = 20 * (tiered.getTier().ordinal() + 1);
        }
        super.tick();
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag coversNbt = new CompoundTag();
        for (Map.Entry<Direction, Multipart> entry : this.parts.entrySet()) {
            if (entry.getValue() == null) continue;
            CompoundTag partNbt = new CompoundTag();
            entry.getValue().writeToNbt(partNbt);
            coversNbt.putCompound(String.valueOf(entry.getKey().ordinal()), partNbt);
        }
        tag.putCompound("Parts", coversNbt);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        CompoundTag coversNbt = tag.getCompound("Parts");
        for (Map.Entry entry : ((Map)coversNbt.getValue()).entrySet()) {
            Direction dir = Direction.values()[Integer.parseInt((String)entry.getKey())];
            CompoundTag partTag = (CompoundTag)entry.getValue();
            this.parts.put(dir, new Multipart(partTag));
        }
    }

    public HashMap<Direction, Multipart> getParts() {
        return this.parts;
    }
}

