/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.io.IFluidIO;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.api.IFluidTransfer;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.interfaces.IAcceptsPosition;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityExternalIO
extends TileEntityTieredMachineBase
implements IAcceptsPosition {
    public TileEntity externalTile;
    public Direction externalTileSide;
    public CompoundTag externalTilePos;
    public static int range = 5;

    public int getActiveFluidSlotForSide(Direction dir) {
        if (this.externalTile instanceof IFluidIO) {
            return ((IFluidIO)this.externalTile).getActiveFluidSlotForSide(dir);
        }
        return 0;
    }

    public Connection getFluidIOForSide(Direction dir) {
        if (this.externalTile instanceof IFluidIO) {
            return ((IFluidIO)this.externalTile).getFluidIOForSide(dir);
        }
        return Connection.NONE;
    }

    public void take(@NotNull FluidStack fluidStack, Direction dir, int slot) {
        if (this.externalTile instanceof IFluidTransfer) {
            ((IFluidTransfer)this.externalTile).take(fluidStack, dir, slot);
        }
    }

    public void give(Direction dir, int slot, int otherSlot) {
        if (this.externalTile instanceof IFluidTransfer) {
            ((IFluidTransfer)this.externalTile).give(dir, slot, otherSlot);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        if (tag.containsKey("externalPosition")) {
            this.externalTilePos = tag.getCompound("externalPosition");
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        if (this.externalTilePos != null) {
            tag.put("externalPosition", (Tag)this.externalTilePos);
        }
        super.writeToNBT(tag);
    }

    public void take(@NotNull FluidStack fluidStack, Direction dir) {
        if (this.externalTile instanceof IFluidTransfer) {
            ((IFluidTransfer)this.externalTile).take(fluidStack, dir);
        }
    }

    public void give(Direction dir) {
        if (this.externalTile instanceof IFluidTransfer) {
            ((IFluidTransfer)this.externalTile).give(dir);
        }
    }

    public FluidStack insertFluid(int slot, FluidStack fluidStack) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).insertFluid(slot, fluidStack);
        }
        return null;
    }

    public int getRemainingCapacity(int slot) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getRemainingCapacity(slot);
        }
        return 0;
    }

    public boolean canInsertFluid(int slot, FluidStack fluidStack) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).canInsertFluid(slot, fluidStack);
        }
        return false;
    }

    public FluidStack getFluidInSlot(int slot) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getFluidInSlot(slot);
        }
        return null;
    }

    public int getFluidCapacityForSlot(int slot) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getFluidCapacityForSlot(slot);
        }
        return 0;
    }

    public ArrayList<Fluid> getAllowedFluidsForSlot(int slot) {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getAllowedFluidsForSlot(slot);
        }
        return new ArrayList<Fluid>();
    }

    public void setFluidInSlot(int slot, FluidStack fluid) {
        if (this.externalTile instanceof IFluidInventory) {
            ((IFluidInventory)this.externalTile).setFluidInSlot(slot, fluid);
        }
    }

    public int getFluidInventorySize() {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getFluidInventorySize();
        }
        return 0;
    }

    public void onFluidInventoryChanged() {
        if (this.externalTile instanceof IFluidInventory) {
            ((IFluidInventory)this.externalTile).onFluidInventoryChanged();
        }
    }

    public int getTransferSpeed() {
        if (this.externalTile instanceof IFluidInventory) {
            return ((IFluidInventory)this.externalTile).getTransferSpeed();
        }
        return 0;
    }

    public int getActiveItemSlotForSide(Direction dir, ItemStack stack) {
        if (this.externalTile instanceof Container) {
            if ((Integer)this.activeItemSlots.get(dir) == -1) {
                if (this.itemConnections.get(dir) == Connection.INPUT) {
                    for (int i = 0; i < ((Container)this.externalTile).getContainerSize(); ++i) {
                        ItemStack content = ((Container)this.externalTile).getItem(i);
                        if (content != null && !content.isItemEqual(stack)) continue;
                        return i;
                    }
                } else if (this.itemConnections.get(dir) == Connection.OUTPUT) {
                    for (int i = 0; i < ((Container)this.externalTile).getContainerSize(); ++i) {
                        ItemStack content = ((Container)this.externalTile).getItem(i);
                        if (content == null) continue;
                        return i;
                    }
                }
                return 0;
            }
            return (Integer)this.activeItemSlots.get(dir);
        }
        return 0;
    }

    public int getContainerSize() {
        if (this.externalTile instanceof Container) {
            return ((Container)this.externalTile).getContainerSize();
        }
        return 0;
    }

    @Nullable
    public ItemStack getItem(int index) {
        if (this.externalTile instanceof Container) {
            return ((Container)this.externalTile).getItem(index);
        }
        return null;
    }

    @Nullable
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.externalTile instanceof Container) {
            return ((Container)this.externalTile).removeItem(index, takeAmount);
        }
        return null;
    }

    public void setItem(int index, @Nullable ItemStack itemstack) {
        if (this.externalTile instanceof Container) {
            ((Container)this.externalTile).setItem(index, itemstack);
        }
    }

    public int getMaxStackSize() {
        if (this.externalTile instanceof Container) {
            return ((Container)this.externalTile).getMaxStackSize();
        }
        return 0;
    }

    public int getActiveItemSlotForSide(Direction dir) {
        if (this.externalTile instanceof IItemIO) {
            return ((IItemIO)this.externalTile).getActiveItemSlotForSide(dir);
        }
        return 0;
    }

    public Connection getItemIOForSide(Direction dir) {
        if (this.externalTile instanceof IItemIO) {
            return ((IItemIO)this.externalTile).getItemIOForSide(dir);
        }
        return Connection.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.externalTile == null) {
            if (this.tier == Tier.BASIC) {
                for (Direction dir : Direction.values()) {
                    TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
                    if (!(tile instanceof Container) && !(tile instanceof IFluidInventory) || tile instanceof TileEntityExternalIO) continue;
                    this.externalTile = tile;
                    this.externalTileSide = dir;
                    CompoundTag pos = new CompoundTag();
                    pos.putInt("x", this.externalTile.x);
                    pos.putInt("y", this.externalTile.y);
                    pos.putInt("z", this.externalTile.z);
                    pos.putInt("side", dir.getSideNumber());
                    pos.putInt("dim", this.externalTile.worldObj.dimension.id);
                    this.externalTilePos = pos;
                }
            } else if (this.tier == Tier.REINFORCED && this.externalTilePos != null && this.externalTilePos.containsKey("x") && this.externalTilePos.containsKey("y") && this.externalTilePos.containsKey("z") && this.externalTilePos.containsKey("dim") && this.externalTilePos.containsKey("side")) {
                TileEntity tile;
                int eX = this.externalTilePos.getInteger("x");
                int eY = this.externalTilePos.getInteger("y");
                int eZ = this.externalTilePos.getInteger("z");
                int dim = this.externalTilePos.getInteger("dim");
                Vec3i pos = new Vec3i(eX, eY, eZ);
                Vec3f selfPos = new Vec3f((double)this.x, (double)this.y, (double)this.z);
                if (pos.distanceTo(selfPos) < (double)range && dim == this.worldObj.dimension.id && ((tile = this.worldObj.getTileEntity(this.externalTilePos.getInteger("x"), this.externalTilePos.getInteger("y"), this.externalTilePos.getInteger("z"))) instanceof Container || tile instanceof IFluidInventory) && !(tile instanceof TileEntityExternalIO)) {
                    this.externalTile = tile;
                    this.externalTileSide = Direction.getDirectionFromSide((int)this.externalTilePos.getInteger("side"));
                }
            }
        } else if (this.worldObj.getTileEntity(this.externalTile.x, this.externalTile.y, this.externalTile.z) != this.externalTile) {
            this.externalTile = null;
            this.externalTileSide = null;
            this.externalTilePos = null;
        }
    }

    public Player getNearestPlayer() {
        int dist = -1;
        Player ret = null;
        for (Player p : this.worldObj.players) {
            int nd = (int)(Math.pow((int)p.x - this.x, 2.0) + Math.pow((int)p.y - this.y, 2.0) + Math.pow((int)p.z - this.z, 2.0));
            if (dist != -1 && nd >= dist) continue;
            ret = p;
            dist = nd;
        }
        return ret;
    }

    @Override
    public void receivePosition(int x, int y, int z, Side side, int dim) {
        if (this.tier == Tier.REINFORCED) {
            Vec3i pos = new Vec3i(x, y, z);
            Vec3f selfPos = new Vec3f((double)this.x, (double)this.y, (double)this.z);
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", x);
            tag.putInt("y", y);
            tag.putInt("z", z);
            tag.putInt("side", side.getId());
            tag.putInt("dim", dim);
            this.externalTilePos = tag;
            TileEntity tile = this.worldObj.getTileEntity(x, y, z);
            if (pos.distanceTo(selfPos) < (double)range) {
                if (dim == this.worldObj.dimension.id) {
                    if (tile instanceof Container || tile instanceof IFluidInventory) {
                        if (!(tile instanceof TileEntityExternalIO)) {
                            this.externalTile = tile;
                            this.externalTileSide = Direction.getDirectionFromSide((int)side.getId());
                            this.getNearestPlayer().sendMessage("Link established!");
                        }
                    } else {
                        this.getNearestPlayer().sendMessage("invalid block at position!");
                    }
                } else {
                    this.getNearestPlayer().sendMessage("Position outside this world!");
                }
            } else {
                this.getNearestPlayer().sendMessage("Position out of reach!");
            }
        }
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.externalIo";
    }
}

