/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.mojang.nbt.tags.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;

public class TileEntityFilter
extends TileEntityFluidItemContainer {
    public boolean ignoreMeta = false;
    public FilterSide defaultSide = FilterSide.MAGENTA;

    public TileEntityFilter() {
        this.fluidContents = new FluidStack[0];
        this.fluidCapacity = new int[0];
        this.itemContents = new ItemStack[54];
    }

    public void tick() {
        this.worldObj.markBlockDirty(this.x, this.y, this.z);
        super.tick();
    }

    public void sort(Direction inputDir, TileEntityItemConduit.PipeItem item, TileEntityItemConduit conduit) {
        FilterSide outputSide = this.getFilterColor(item.getStack());
        if (outputSide == null) {
            conduit.dropItem(item, null);
            return;
        }
        Set<Direction> directionSet = this.getSurroundings().keySet();
        if (!directionSet.contains(outputSide.getDirection())) {
            conduit.dropItem(item, null);
            return;
        }
        for (Map.Entry<Direction, TileEntityItemConduit> entry : this.getSurroundings().entrySet()) {
            if (entry.getKey() != outputSide.getDirection()) continue;
            TileEntityItemConduit tile = entry.getValue();
            boolean success = tile.addItem(item.getStack(), outputSide.getDirection().getOpposite());
            if (!success) {
                conduit.dropItem(item, null);
                return;
            }
            conduit.getContents().remove(item);
            return;
        }
    }

    public HashMap<Direction, TileEntityItemConduit> getSurroundings() {
        HashMap<Direction, TileEntityItemConduit> surroundings = new HashMap<Direction, TileEntityItemConduit>();
        for (Direction dir : Direction.values()) {
            TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
            if (tile == null || !(tile instanceof TileEntityItemConduit)) continue;
            surroundings.put(dir, (TileEntityItemConduit)tile);
        }
        return surroundings;
    }

    public FilterSide getFilterColor(ItemStack stack) {
        for (int i2 = 0; i2 < this.itemContents.length; ++i2) {
            if ((this.itemContents[i2] == null || this.itemContents[i2].itemID != stack.itemID || this.itemContents[i2].getMetadata() != stack.getMetadata()) && !this.ignoreMeta) continue;
            return FilterSide.values()[i2 / 9];
        }
        return this.defaultSide;
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putBoolean("IgnoreMeta", this.ignoreMeta);
        tag.putInt("DefaultSide", this.defaultSide.ordinal());
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.ignoreMeta = tag.getBoolean("IgnoreMeta");
        this.defaultSide = FilterSide.values()[tag.getInteger("DefaultSide")];
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.filter";
    }

    public static enum FilterSide {
        RED(Direction.Y_POS),
        GREEN(Direction.Z_POS),
        BLUE(Direction.X_POS),
        CYAN(Direction.Y_NEG),
        MAGENTA(Direction.Z_NEG),
        YELLOW(Direction.X_NEG);

        private final Direction direction;

        private FilterSide(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public static FilterSide getFromDirection(Direction dir) {
            for (FilterSide side : FilterSide.values()) {
                if (side.getDirection() != dir) continue;
                return side;
            }
            return null;
        }
    }
}

