/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.io.InventoryWrapper;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityStorageContainer;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBooster;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityInserter
extends TileEntity
implements IBoostable {
    public static final int MAX_WORK_TICKS = 60;
    public TickTimer workTimer = new TickTimer((Object)this, this::work, 60, true);
    public Direction input = Direction.Z_NEG;
    public Direction output = Direction.Z_POS;
    public float speedMultiplier = 1.0f;
    private Tier tier = Tier.PROTOTYPE;

    public void tick() {
        super.tick();
        this.workTimer.tick();
        this.workTimer.max = (int)(60.0f / this.speedMultiplier + (float)(this.tier.ordinal() + 1));
        this.input = Direction.getDirectionFromSide((int)this.worldObj.getBlockMetadata(this.x, this.y, this.z));
        this.output = this.input.getOpposite();
        Block block = this.getBlock();
        if (block != null) {
            this.tier = ((ITiered)block.getLogic()).getTier();
            this.applyModifiers();
        }
    }

    public void applyModifiers() {
        this.speedMultiplier = 1.0f;
        for (Direction dir : Direction.values()) {
            int meta;
            TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
            if (!(tile instanceof TileEntityBooster) || !((TileEntityBooster)tile).isBurning() || Direction.getDirectionFromSide((int)(meta = tile.getBlockMeta())).getOpposite() != dir) continue;
            if (((TileEntityBooster)tile).tier == Tier.BASIC) {
                this.speedMultiplier = 1.5f;
                continue;
            }
            if (((TileEntityBooster)tile).tier == Tier.REINFORCED) {
                this.speedMultiplier = 2.0f;
                continue;
            }
            if (((TileEntityBooster)tile).tier != Tier.AWAKENED) continue;
            this.speedMultiplier = 3.0f;
        }
    }

    public void work() {
        block13: {
            ArrayList items;
            TileEntity pipe;
            block11: {
                boolean success;
                TileEntity inv;
                block12: {
                    ItemStack leftovers;
                    ItemStack stack;
                    inv = this.input.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
                    pipe = this.output.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
                    if (this.getBlock() == null) {
                        return;
                    }
                    AABB aabb = this.getBlock().getSelectedBoundingBoxFromPool((WorldSource)this.worldObj, this.x, this.y, this.z).copy().move(this.input.getVecF().x, this.input.getVecF().y, this.input.getVecF().z);
                    items = new ArrayList(this.worldObj.getEntitiesWithinAABB(EntityItem.class, aabb));
                    if (!(pipe instanceof TileEntityItemConduit) || !(inv instanceof Container) && !(inv instanceof TileEntityStorageContainer)) break block11;
                    if (!(inv instanceof Container)) break block12;
                    int slot = -1;
                    for (int i = 0; i < ((Container)inv).getContainerSize(); ++i) {
                        stack = ((Container)inv).getItem(i);
                        if (stack == null) continue;
                        slot = i;
                    }
                    if (slot == -1) {
                        return;
                    }
                    int maxSplit = (int)Math.min(64.0f, 4.0f * this.speedMultiplier * (float)(this.tier.ordinal() + 1));
                    stack = ((Container)inv).getItem(slot);
                    if (stack == null) {
                        return;
                    }
                    InventoryWrapper wrapper = new InventoryWrapper((Container)inv);
                    ItemStack toInsert = wrapper.removeUntil(stack.itemID, stack.getMetadata(), (long)maxSplit, stack.getData(), false, false);
                    boolean success2 = ((TileEntityItemConduit)pipe).addItem(toInsert, this.output.getOpposite());
                    if (success2 || (leftovers = wrapper.add(toInsert)) == null) break block13;
                    Vec3f vec = new Vec3f((double)this.x, (double)this.y, (double)this.z).add(Direction.getDirectionFromSide((int)this.worldObj.getBlockMetadata(this.x, this.y, this.z)).getVecF()).add(0.5);
                    EntityItem entityitem = new EntityItem(this.worldObj, vec.x, vec.y, vec.z, leftovers);
                    this.worldObj.entityJoinedWorld((Entity)entityitem);
                    break block13;
                }
                TileEntityStorageContainer container = (TileEntityStorageContainer)inv;
                int maxSplit = (int)Math.min(64.0f, 4.0f * this.speedMultiplier * (float)(this.tier.ordinal() + 1));
                ItemStack stack = container.extractStack(maxSplit);
                if (stack == null || (success = ((TileEntityItemConduit)pipe).addItem(stack, this.output.getOpposite()))) break block13;
                Vec3f vec = new Vec3f((double)this.x, (double)this.y, (double)this.z).add(Direction.getDirectionFromSide((int)this.worldObj.getBlockMetadata(this.x, this.y, this.z)).getVecF()).add(0.5);
                EntityItem entityitem = new EntityItem(this.worldObj, vec.x, vec.y, vec.z, stack);
                this.worldObj.entityJoinedWorld((Entity)entityitem);
                break block13;
            }
            if (pipe instanceof TileEntityItemConduit && !items.isEmpty()) {
                EntityItem item = (EntityItem)items.get(0);
                int maxSplit = (int)Math.min(64.0f, 4.0f * this.speedMultiplier * (float)(this.tier.ordinal() + 1));
                ItemStack split = item.item.stackSize >= maxSplit ? item.item.splitStack(maxSplit) : item.item.splitStack(item.item.stackSize);
                boolean success = ((TileEntityItemConduit)pipe).addItem(split, this.output.getOpposite());
                if (!success) {
                    item.item.stackSize += split.stackSize;
                } else if (item.item.itemID < 16384) {
                    for (int i = 0; i < 4; ++i) {
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                    }
                }
            }
        }
    }
}

