/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.base;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.signalindustries.covers.DilithiumLensCover;
import sunsetsatellite.signalindustries.covers.SwitchCover;
import sunsetsatellite.signalindustries.interfaces.IActiveForm;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.interfaces.IBooster;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredContainer;
import sunsetsatellite.signalindustries.util.IOPreview;
import sunsetsatellite.signalindustries.util.Tier;

public abstract class TileEntityTieredMachineBase
extends TileEntityTieredContainer
implements IHasIOPreview,
IActiveForm {
    public int fuelBurnTicks = 0;
    public int fuelMaxBurnTicks = 0;
    public int progressTicks = 0;
    public int progressMaxTicks = 200;
    public float speedMultiplier = 1.0f;
    public float yield = 1.0f;
    public IOPreview preview = IOPreview.NONE;
    public TickTimer IOPreviewTimer = new TickTimer((Object)this, this::disableIOPreview, 20, false);
    public boolean disabled = false;

    @Override
    public void disableIOPreview() {
        this.preview = IOPreview.NONE;
    }

    @Override
    public void setTemporaryIOPreview(IOPreview preview, int ticks) {
        this.IOPreviewTimer.value = ticks;
        this.IOPreviewTimer.max = ticks;
        this.IOPreviewTimer.unpause();
        this.preview = preview;
    }

    @Override
    public boolean isBurning() {
        return this.fuelBurnTicks > 0;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.worldObj.isClientSide) {
            return;
        }
        this.IOPreviewTimer.tick();
        Block block = this.getBlock();
        if (block != null) {
            this.applyModifiers();
        }
    }

    public void applyModifiers() {
        this.speedMultiplier = 1.0f;
        this.yield = 1.0f;
        for (Direction dir : Direction.values()) {
            int meta;
            Direction side;
            TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
            if (!(tile instanceof IBooster) || !(this instanceof IBoostable) || !((IBooster)tile).isBurning() || (side = Direction.getDirectionFromSide((int)(meta = tile.getBlockMeta()))).getOpposite() != dir) continue;
            if (((IBooster)tile).getTier() == Tier.BASIC) {
                this.speedMultiplier = 1.5f;
                if (!((IBooster)tile).hasCover(side, DilithiumLensCover.class)) continue;
                this.speedMultiplier = 1.75f;
                continue;
            }
            if (((IBooster)tile).getTier() == Tier.REINFORCED) {
                this.speedMultiplier = 2.0f;
                if (!((IBooster)tile).hasCover(side, DilithiumLensCover.class)) continue;
                this.speedMultiplier = 2.5f;
                continue;
            }
            if (((IBooster)tile).getTier() != Tier.AWAKENED) continue;
            this.speedMultiplier = 3.0f;
            if (!((IBooster)tile).hasCover(side, DilithiumLensCover.class)) continue;
            this.speedMultiplier = 4.0f;
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putShort("BurnTime", (short)this.fuelBurnTicks);
        tag.putShort("ProcessTime", (short)this.progressTicks);
        tag.putShort("MaxBurnTime", (short)this.fuelMaxBurnTicks);
        tag.putInt("MaxProcessTime", this.progressMaxTicks);
        tag.putBoolean("Disabled", this.disabled);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.fuelBurnTicks = tag.getShort("BurnTime");
        this.progressTicks = tag.getShort("ProcessTime");
        this.progressMaxTicks = tag.getInteger("MaxProcessTime");
        this.fuelMaxBurnTicks = tag.getShort("MaxBurnTime");
        this.disabled = tag.getBoolean("Disabled");
    }

    public int getTieredProgressDuration(int defaultTicks) {
        return (int)((float)defaultTicks / (float)(this.tier.ordinal() + 1) / this.speedMultiplier);
    }

    public int getProgressScaled(int paramInt) {
        return this.progressTicks * paramInt / this.progressMaxTicks;
    }

    public int getBurnTimeRemainingScaled(int paramInt) {
        if (this.fuelMaxBurnTicks == 0) {
            this.fuelMaxBurnTicks = 200;
        }
        return this.fuelBurnTicks * paramInt / this.fuelMaxBurnTicks;
    }

    @Override
    public IOPreview getPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(IOPreview preview) {
        this.preview = preview;
    }

    public void onPoweredBlockChange(boolean powered) {
        if (this.hasCoverAnywhere(SwitchCover.class)) {
            this.disabled = powered;
        }
    }
}

