/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.Chunk;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.IScreenActionListener;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.vector.Vec2i;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityAutoMiner
extends TileEntityTieredMachineBase
implements IBoostable,
IScreenActionListener {
    public Vec2i maxSize = new Vec2i(16, 16);
    public Vec2i size = new Vec2i(0, 0);
    public Vec3i current = new Vec3i();
    public TickTimer workTimer = new TickTimer((Object)this, this::work, this.progressMaxTicks, true);
    public int cost;
    public int multiplier = 1;

    public TileEntityAutoMiner() {
        this.progressMaxTicks = 5;
        this.fuelMaxBurnTicks = 20;
        this.cost = 1;
        this.itemContents = new ItemStack[1];
        this.fluidCapacity[0] = 16383;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.workTimer.pause();
        this.transferSpeed = 50;
        this.itemConnections.replace(Direction.Y_POS, Connection.OUTPUT);
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        Vec2i vec2i = this.maxSize = this.tier == Tier.BASIC ? new Vec2i(16, 16) : new Vec2i(32, 32);
        if (this.size.x == 0 || this.size.y == 0) {
            this.size = this.maxSize.copy();
        }
        this.multiplier = this.tier == Tier.BASIC ? 1 : 2;
    }

    public void work() {
        if (this.fuelBurnTicks == 0 && this.fluidContents[0] != null && this.fluidContents[0].amount > this.cost) {
            this.fluidContents[0].amount -= this.cost;
            this.fuelBurnTicks = this.fuelMaxBurnTicks;
            if (this.fluidContents[0].amount <= 0) {
                this.fluidContents[0] = null;
            }
        }
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
            for (int m = 0; m < this.multiplier; ++m) {
                this.current.y = this.findTopSolidNonLiquidBlockLimited(this.worldObj, this.current.x, this.current.z, this.y + 4);
                if (this.worldObj.getBlockId(this.current.x, this.current.y - 1, this.current.z) != Blocks.BEDROCK.id()) {
                    Block block = Blocks.getBlock((int)this.worldObj.getBlockId(this.current.x, this.current.y - 1, this.current.z));
                    boolean silk = this.hasSilkTouch();
                    if (block != null) {
                        int meta = this.worldObj.getBlockMetadata(this.current.x, this.current.y - 1, this.current.z);
                        Direction dir = null;
                        for (Direction direction : Direction.values()) {
                            if (this.itemConnections.get(direction) != Connection.OUTPUT && this.itemConnections.get(direction) != Connection.BOTH || !(direction.getTileEntity((WorldSource)this.worldObj, (TileEntity)this) instanceof TileEntityChest) && !(direction.getTileEntity((WorldSource)this.worldObj, (TileEntity)this) instanceof TileEntityItemConduit)) continue;
                            dir = direction;
                        }
                        if (dir != null) {
                            ItemStack drop;
                            int n;
                            TileEntity tile = dir.getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
                            ItemStack[] drops = block.getBreakResult(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y, this.z, meta, tile);
                            if (block.hasTag(SignalIndustries.ORE_BLOCK) && this.tier == Tier.REINFORCED) {
                                ItemStack[] itemStackArray = drops;
                                int n2 = itemStackArray.length;
                                for (n = 0; n < n2; ++n) {
                                    drop = itemStackArray[n];
                                    drop.stackSize *= 2;
                                }
                            }
                            if (tile instanceof TileEntityChest) {
                                if (drops == null) {
                                    block.dropBlockWithCause(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y + 1, this.z, meta, (TileEntity)this, null);
                                    this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                                    return;
                                }
                                ItemStack[] itemStackArray = drops;
                                int n3 = itemStackArray.length;
                                for (n = 0; n < n3; ++n) {
                                    drop = itemStackArray[n];
                                    int availableSlot = -1;
                                    for (int i = 0; i < ((TileEntityChest)tile).getContainerSize(); ++i) {
                                        ItemStack stack = ((TileEntityChest)tile).getItem(i);
                                        if (stack != null && (!stack.isItemEqual(drop) || stack.stackSize >= stack.getMaxStackSize())) continue;
                                        availableSlot = i;
                                        break;
                                    }
                                    if (availableSlot == -1) {
                                        block.dropBlockWithCause(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y + 1, this.z, meta, (TileEntity)this, null);
                                        this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                                        continue;
                                    }
                                    ItemStack stack = ((TileEntityChest)tile).getItem(availableSlot);
                                    if (stack == null) {
                                        ((TileEntityChest)tile).setItem(availableSlot, drop);
                                    } else if (stack.isItemEqual(drop)) {
                                        stack.stackSize += drop.stackSize;
                                    }
                                    this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                                }
                            } else if (tile instanceof TileEntityItemConduit) {
                                if (drops != null) {
                                    ItemStack[] itemStackArray = drops;
                                    int n4 = itemStackArray.length;
                                    for (n = 0; n < n4; ++n) {
                                        drop = itemStackArray[n];
                                        if (drop == null) continue;
                                        boolean success = ((TileEntityItemConduit)tile).addItem(drop, dir.getOpposite());
                                        if (!success) {
                                            block.dropBlockWithCause(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y + 1, this.z, meta, (TileEntity)this, null);
                                        }
                                        this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                                    }
                                }
                            } else {
                                block.dropBlockWithCause(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y + 1, this.z, meta, (TileEntity)this, null);
                                this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                            }
                        } else {
                            block.dropBlockWithCause(this.worldObj, silk ? EnumDropCause.SILK_TOUCH : EnumDropCause.PROPER_TOOL, this.x, this.y + 1, this.z, meta, (TileEntity)this, null);
                            this.worldObj.setBlockWithNotify(this.current.x, this.current.y - 1, this.current.z, 0);
                        }
                    }
                }
                --this.current.x;
                if (this.current.y < 1) {
                    this.current.y = this.y + 4;
                }
                if (this.current.x >= this.x - (this.size.x - 2)) continue;
                this.current.x = this.x - 1;
                ++this.current.z;
                this.current.y = this.findTopSolidNonLiquidBlockLimited(this.worldObj, this.current.x, this.current.z, this.y + 4);
                if (this.current.z <= this.z + (this.size.y - 2)) continue;
                this.current.z = this.z + 1;
                this.current.y = this.findTopSolidNonLiquidBlockLimited(this.worldObj, this.current.x, this.current.z, this.y + 4);
            }
        }
    }

    @Override
    public void tick() {
        if (this.worldObj != null) {
            boolean silk;
            this.applyModifiers();
            this.extractFluids();
            if (!this.workTimer.isPaused()) {
                this.workTimer.tick();
            }
            if (this.current.equals((Object)new Vec3i())) {
                this.current = new Vec3i(this.x - 1, this.y + 4, this.z + 1);
            }
            if (silk = this.hasSilkTouch()) {
                this.cost = 2;
                this.workTimer.max = (int)((float)this.progressMaxTicks / this.speedMultiplier) * 2;
            } else {
                this.cost = 1;
                this.workTimer.max = (int)((float)this.progressMaxTicks / this.speedMultiplier);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag sizeTag = new CompoundTag();
        this.size.writeToNBT(sizeTag);
        tag.put("Size", (Tag)sizeTag);
        tag.putBoolean("Active", !this.workTimer.isPaused());
        CompoundTag currentTag = new CompoundTag();
        this.current.writeToNBT(currentTag);
        tag.put("Current", (Tag)currentTag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        CompoundTag sizeTag = tag.getCompound("Size");
        this.size.readFromNBT(sizeTag);
        boolean active = tag.getBoolean("Active");
        if (active && this.workTimer.isPaused()) {
            this.workTimer.unpause();
        } else {
            this.workTimer.pause();
        }
        CompoundTag currentTag = tag.getCompound("Current");
        this.current.readFromNBT(currentTag);
    }

    public int findTopSolidNonLiquidBlockLimited(World world, int x, int z, int yLimit) {
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        x &= 0xF;
        z &= 0xF;
        for (int k = Math.min(yLimit, world.getHeightBlocks() - 1); k > 0; --k) {
            Material material;
            int l = chunk.getBlockID(x, k, z);
            Material material2 = material = l != 0 ? Blocks.blocksList[l].getMaterial() : Material.air;
            if (!material.blocksMotion()) continue;
            return k + 1;
        }
        return -1;
    }

    @Override
    public boolean isBurning() {
        return this.fluidContents[0] != null;
    }

    public boolean hasSilkTouch() {
        return this.getItem(0) != null && this.getItem(0).getItem().equals(SIItems.precisionControlChip);
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.autoMiner";
    }

    @Override
    public void buttonClicked(int id, int button, int channel) {
        switch (id) {
            case 3: {
                if (this.size.x >= this.maxSize.x) break;
                ++this.size.x;
                break;
            }
            case 4: {
                if (this.size.x <= 1) break;
                --this.size.x;
                break;
            }
            case 5: {
                if (this.size.y >= this.maxSize.y) break;
                ++this.size.y;
                break;
            }
            case 6: {
                if (this.size.y <= 1) break;
                --this.size.y;
            }
        }
    }
}

