/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.interfaces.IBooster;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredContainer;
import sunsetsatellite.signalindustries.util.IOPreview;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityBooster
extends TileEntityTieredContainer
implements IHasIOPreview,
IBooster {
    public int fuelBurnTicks = 0;
    public int fuelMaxBurnTicks = 0;
    public int progressTicks = 0;
    public int progressMaxTicks = 200;
    public int efficiency = 1;
    public int speedMultiplier = 1;
    public int cost = 40;
    public Random random = new Random();
    public IOPreview preview = IOPreview.NONE;
    public TickTimer IOPreviewTimer = new TickTimer((Object)this, this::disableIOPreview, 20, false);

    @Override
    public void disableIOPreview() {
        this.preview = IOPreview.NONE;
    }

    @Override
    public void setTemporaryIOPreview(IOPreview preview, int ticks) {
        this.IOPreviewTimer.value = ticks;
        this.IOPreviewTimer.max = ticks;
        this.IOPreviewTimer.unpause();
        this.preview = preview;
    }

    public TileEntityBooster() {
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 4000;
        for (FluidStack ignored : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.itemContents = new ItemStack[1];
    }

    @Override
    public void tick() {
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.IOPreviewTimer.tick();
        this.extractFluids();
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (!this.worldObj.isClientSide) {
            if (this.isBurning() && this.canProcess()) {
                if (this.progressTicks > 0) {
                    --this.progressTicks;
                    Vec3f color = new Vec3f();
                    if (this.tier == Tier.BASIC) {
                        color.x = 1.0;
                    } else if (this.tier == Tier.REINFORCED) {
                        color.x = 1.0;
                        color.z = 1.0;
                    } else if (this.tier == Tier.AWAKENED) {
                        color.x = 1.0;
                        color.y = 0.6470588445663452;
                    }
                    int meta = this.worldObj.getBlockMetadata(this.x, this.y, this.z);
                    TileEntity tileEntity = Direction.getDirectionFromSide((int)meta).getTileEntity((WorldSource)this.worldObj, (TileEntity)this);
                    if (tileEntity instanceof IBoostable) {
                        if (this.tier == Tier.BASIC) {
                            color.x = 1.0;
                            color.y = 0.5;
                            color.z = 0.5;
                        } else if (this.tier == Tier.REINFORCED) {
                            color.x = 1.0;
                            color.z = 0.5;
                        } else if (this.tier == Tier.AWAKENED) {
                            color.x = 1.0;
                            color.y = 0.6470588445663452;
                            color.z = 0.5;
                        }
                    }
                }
                if (this.progressTicks <= 0) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public int getProgressScaled(int paramInt) {
        return this.progressTicks * paramInt / this.progressMaxTicks;
    }

    public int getBurnTimeRemainingScaled(int paramInt) {
        if (this.fuelMaxBurnTicks == 0) {
            this.fuelMaxBurnTicks = 400;
        }
        return this.fuelBurnTicks * paramInt / this.fuelMaxBurnTicks;
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= this.cost) {
            this.setFuel();
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= this.cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess() && this.progressTicks <= 0) {
            this.setFuel();
            --this.itemContents[0].stackSize;
            if (this.itemContents[0].stackSize <= 0) {
                this.itemContents[0] = null;
            }
            this.progressTicks = this.progressMaxTicks;
        }
    }

    public void setFuel() {
        if (this.canProcess() && this.progressTicks <= 0) {
            if (this.tier == Tier.BASIC) {
                if (this.itemContents[0].getItem().equals(Items.DUST_REDSTONE)) {
                    this.progressMaxTicks = 150 * this.speedMultiplier;
                } else if (this.itemContents[0].itemID == Blocks.BLOCK_REDSTONE.id()) {
                    this.progressMaxTicks = 1500 * this.speedMultiplier;
                }
            } else if (this.itemContents[0].getItem().equals(SIItems.dilithiumShard)) {
                this.progressMaxTicks = 300 * this.speedMultiplier;
            } else if (this.itemContents[0].itemID == SIBlocks.dilithiumBlock.id()) {
                this.progressMaxTicks = 3000 * this.speedMultiplier;
            }
        }
    }

    private boolean canProcess() {
        if (this.itemContents[0] == null) {
            return false;
        }
        if (this.tier == Tier.BASIC) {
            return (this.itemContents[0].getItem().equals(Items.DUST_REDSTONE) || this.itemContents[0].itemID == Blocks.BLOCK_REDSTONE.id()) && this.itemContents[0].stackSize > 0;
        }
        return (this.itemContents[0].getItem().equals(SIItems.dilithiumShard) || this.itemContents[0].itemID == SIBlocks.dilithiumBlock.id()) && this.itemContents[0].stackSize > 0;
    }

    @Override
    public boolean isBurning() {
        return this.fuelBurnTicks > 0;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putShort("BurnTime", (short)this.fuelBurnTicks);
        tag.putShort("ProcessTime", (short)this.progressTicks);
        tag.putShort("MaxBurnTime", (short)this.fuelMaxBurnTicks);
        tag.putInt("MaxProcessTime", this.progressMaxTicks);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.fuelBurnTicks = tag.getShort("BurnTime");
        this.progressTicks = tag.getShort("ProcessTime");
        this.progressMaxTicks = tag.getInteger("MaxProcessTime");
        this.fuelMaxBurnTicks = tag.getShort("MaxBurnTime");
    }

    @Override
    public IOPreview getPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(IOPreview preview) {
        this.preview = preview;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.booster";
    }
}

