/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineSimple;

public class TileEntityCrystalChamber
extends TileEntityTieredMachineSimple
implements IBoostable {
    public TileEntityCrystalChamber() {
        this.fluidContents = new FluidStack[2];
        this.fluidCapacity = new int[2];
        this.fluidCapacity[0] = 4000;
        this.fluidCapacity[1] = 4000;
        this.itemContents = new ItemStack[3];
        for (FluidStack ignored : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.energySlot = 0;
        this.recipeGroup = SIRecipes.CRYSTAL_CHAMBER;
        this.itemInputs = new int[]{0, 2};
        this.itemOutputs = new int[]{1};
        this.fluidInputs = new int[]{1};
    }

    @Override
    public boolean canProcess() {
        ItemStack c1 = this.itemContents[this.itemInputs[0]];
        ItemStack c2 = this.itemContents[this.itemInputs[1]];
        if (c1 != null && c2 != null && c1.getData().getInteger("size") + c2.getData().getInteger("size") > 8 * this.tier.ordinal()) {
            return false;
        }
        return super.canProcess();
    }

    @Override
    public void processItem() {
        if (this.canProcess()) {
            int size1 = this.itemContents[this.itemInputs[0]].getData().getInteger("size");
            int sat1 = this.itemContents[this.itemInputs[0]].getData().getInteger("saturation");
            int size2 = this.itemContents[this.itemInputs[1]].getData().getInteger("size");
            int sat2 = this.itemContents[this.itemInputs[1]].getData().getInteger("saturation");
            super.processItem();
            if (this.itemContents[this.itemOutputs[0]] != null) {
                this.itemContents[this.itemOutputs[0]].getData().putInt("size", size1 + size2);
                this.itemContents[this.itemOutputs[0]].getData().putInt("saturation", sat1 + sat2);
            }
        }
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.crystalChamber";
    }
}

