/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.items.ItemRomChip;
import sunsetsatellite.signalindustries.items.applications.ItemTrigger;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityProgrammer
extends TileEntityTieredMachineBase {
    public int cost;

    public TileEntityProgrammer() {
        this.itemContents = new ItemStack[2];
        this.cost = 120;
        this.fluidCapacity[0] = 2000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
    }

    @Override
    public void tick() {
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.extractFluids();
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.itemContents[0] == null || this.itemContents[1] == null) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)(1000.0f / this.speedMultiplier);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess()) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= this.cost) {
            this.progressMaxTicks = (int)(200.0f / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= this.cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess()) {
            ItemStack chip = this.itemContents[0];
            ItemStack trigger = this.itemContents[1];
            String[] key = chip.getItemKey().split("\\.");
            trigger.getData().putString("ability", key[key.length - 1]);
        }
    }

    public boolean canProcess() {
        if (this.itemContents[0] == null || this.itemContents[1] == null) {
            return false;
        }
        if (this.itemContents[0].getItem() instanceof ItemRomChip && this.itemContents[1].getItem() instanceof ItemTrigger) {
            return !this.itemContents[1].getData().containsKey("ability");
        }
        return false;
    }

    public String getNameTranslationKey() {
        if (this.tier == Tier.REINFORCED) {
            return "container.signalindustries.reinforcedProgrammer";
        }
        return "container.signalindustries.programmer";
    }
}

