/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class TileEntityPump
extends TileEntityTieredMachineBase
implements IBoostable {
    public BlockInstance currentBlock = null;
    public Fluid currentFluid = null;
    public RecipeEntrySI<?, ?, RecipeProperties> currentRecipe;
    public TickTimer pumpTimer = new TickTimer((Object)this, this::findFluid, 20, true);
    public int range = 3;
    public Random rand = new Random();

    public TileEntityPump() {
        this.fluidContents = new FluidStack[2];
        this.itemContents = new ItemStack[0];
        this.fluidCapacity = new int[2];
        this.fluidCapacity[0] = 2000;
        this.fluidCapacity[1] = 2000;
        this.progressMaxTicks = 600;
        for (FluidStack ignored : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(1)).addAll(Fluid.fluidMap.values().stream().filter(F -> F != SIFluids.ENERGY).collect(Collectors.toList()));
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
    }

    public void findFluid() {
        if (this.worldObj == null) {
            return;
        }
        if (this.currentBlock == null || this.currentRecipe == null || this.currentFluid == null) {
            HashSet<Fluid> pumpableFluids = new HashSet<Fluid>();
            for (RecipeEntryMachineFluid recipe : SIRecipes.PUMP.getAllRecipes()) {
                pumpableFluids.add(((FluidStack)recipe.getOutput()).fluid);
            }
            for (int pumpX = this.x - this.range; pumpX < this.x + this.range; ++pumpX) {
                for (int pumpY = this.y - 1; pumpY > this.y - this.range - 1; --pumpY) {
                    for (int pumpZ = this.z - this.range; pumpZ < this.z + this.range; ++pumpZ) {
                        List fluids;
                        Block block = this.worldObj.getBlock(pumpX, pumpY, pumpZ);
                        int metadata = this.worldObj.getBlockMetadata(pumpX, pumpY, pumpZ);
                        BlockLogicFluid logic = (BlockLogicFluid)Catalyst.blockLogic((Block)block, BlockLogicFluid.class);
                        if (block != null && block == SIBlocks.eternalTreeLog && metadata == 1) {
                            this.currentBlock = new BlockInstance(block, new Vec3i(pumpX, pumpY, pumpZ), metadata, null);
                            this.currentFluid = SIFluids.WORLD_RESIN;
                            this.currentRecipe = (RecipeEntrySI)((Object)SIRecipes.PUMP.getItem("world_resin"));
                            return;
                        }
                        if (block == null || logic == null || (fluids = pumpableFluids.stream().filter(F -> F.blocks.contains(block)).collect(Collectors.toList())).isEmpty()) continue;
                        this.currentBlock = new BlockInstance(block, new Vec3i(pumpX, pumpY, pumpZ), null);
                        this.currentFluid = (Fluid)fluids.get(0);
                        this.currentRecipe = SIRecipes.PUMP.findRecipe(RecipeExtendedSymbol.arrayOf((Object[])new Object[]{new FluidStack((Fluid)fluids.get(0), 1000)}), this.tier);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        this.range = 3 * (this.tier.ordinal() + 1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.worldObj != null && this.worldObj.isClientSide) {
            return;
        }
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.pumpTimer.tick();
        this.extractFluids();
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.fluidContents[0] == null) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess()) {
                update = this.fuel();
            } else if (this.progressTicks > 0 && this.fuelBurnTicks <= 0 && this.canProcess()) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= ((RecipeProperties)this.currentRecipe.getData()).cost) {
            this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= ((RecipeProperties)this.currentRecipe.getData()).cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess() && this.worldObj != null) {
            FluidStack stack = SIRecipes.PUMP.findFluidOutput(new FluidStack(this.currentFluid), this.tier);
            if (this.currentBlock.block == SIBlocks.eternalTreeLog && this.currentBlock.meta == 1) {
                stack = (FluidStack)((RecipeEntryMachineFluid)((Object)SIRecipes.PUMP.getItem("world_resin"))).getOutput();
            }
            if (this.fluidContents[1] == null) {
                this.setFluidInSlot(1, stack);
            } else if (this.getFluidInSlot((int)1).fluid == stack.fluid) {
                this.fluidContents[1].amount += stack.amount;
            }
            if (this.currentBlock.block == SIBlocks.eternalTreeLog && this.currentBlock.meta == 1) {
                if (this.rand.nextInt(8) == 0) {
                    this.worldObj.setBlockMetadataWithNotify(this.currentBlock.pos.x, this.currentBlock.pos.y, this.currentBlock.pos.z, 0);
                }
            } else {
                this.worldObj.setBlockWithNotify(this.currentBlock.pos.x, this.currentBlock.pos.y, this.currentBlock.pos.z, 0);
            }
            this.currentBlock = null;
            this.currentFluid = null;
        }
    }

    private boolean canProcess() {
        if (this.currentBlock == null || this.currentRecipe == null || this.currentFluid == null) {
            return false;
        }
        if (this.currentBlock.block == SIBlocks.eternalTreeLog && this.currentBlock.meta == 1) {
            FluidStack stack = (FluidStack)((RecipeEntryMachineFluid)((Object)SIRecipes.PUMP.getItem("world_resin"))).getOutput();
            return stack != null && (this.fluidContents[1] == null || this.fluidContents[1].isFluidEqual(stack) && this.fluidContents[1].amount + stack.amount <= this.fluidCapacity[1]);
        }
        FluidStack stack = SIRecipes.PUMP.findFluidOutput(new FluidStack(this.currentFluid), this.tier);
        return stack != null && (this.fluidContents[1] == null || this.fluidContents[1].isFluidEqual(stack) && this.fluidContents[1].amount + stack.amount <= this.fluidCapacity[1]);
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.pump";
    }
}

