/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.covers.DilithiumLensCover;
import sunsetsatellite.signalindustries.interfaces.IActiveForm;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.interfaces.IStabilizable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredContainer;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityDimensionalAnchor;
import sunsetsatellite.signalindustries.util.IOPreview;

public class TileEntityStabilizer
extends TileEntityTieredContainer
implements IMultiblockPart,
IHasIOPreview,
IActiveForm {
    public int fuelBurnTicks = 0;
    public int fuelMaxBurnTicks = 0;
    public int progressTicks = 0;
    public int progressMaxTicks = 200;
    public int efficiency = 1;
    public int speedMultiplier = 1;
    public int cost = 160;
    public Random random = new Random();
    public TileEntity connectedTo;
    public IOPreview preview = IOPreview.NONE;
    public TickTimer IOPreviewTimer = new TickTimer((Object)this, this::disableIOPreview, 20, false);

    @Override
    public void disableIOPreview() {
        this.preview = IOPreview.NONE;
    }

    @Override
    public void setTemporaryIOPreview(IOPreview preview, int ticks) {
        this.IOPreviewTimer.value = ticks;
        this.IOPreviewTimer.max = ticks;
        this.IOPreviewTimer.unpause();
        this.preview = preview;
    }

    public TileEntityStabilizer() {
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 4000;
        for (FluidStack ignored : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.itemContents = new ItemStack[1];
    }

    @Override
    public void tick() {
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.IOPreviewTimer.tick();
        this.extractFluids();
        boolean update = false;
        if (!this.worldObj.isClientSide) {
            if (this.fuelBurnTicks > 0) {
                --this.fuelBurnTicks;
            }
            if (this.isBurning() && this.canProcess()) {
                if (this.progressTicks > 0 && this.connectedTo instanceof IStabilizable && ((IStabilizable)this.connectedTo).isActive()) {
                    --this.progressTicks;
                    if (this.connectedTo instanceof TileEntityDimensionalAnchor) {
                        int temp;
                        Vec3i pos = new Vec3i(this.x, this.y, this.z);
                        Vec3i connectedPos = new Vec3i(this.connectedTo.x, this.connectedTo.y, this.connectedTo.z);
                        if (pos.x > connectedPos.x) {
                            temp = pos.x;
                            pos.x = connectedPos.x;
                            connectedPos.x = temp;
                        }
                        if (pos.z > connectedPos.z) {
                            temp = pos.z;
                            pos.z = connectedPos.z;
                            connectedPos.z = temp;
                        }
                        for (float i = (float)pos.x; i <= (float)connectedPos.x; i += 0.1f) {
                            for (float k = (float)pos.z; k <= (float)connectedPos.z; k += 0.1f) {
                                for (float l = 0.0f; l < 4.0f; l += 1.0f) {
                                }
                            }
                        }
                    }
                }
                if (this.progressTicks <= 0) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess() && this.connectedTo instanceof IStabilizable && ((IStabilizable)this.connectedTo).isActive()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public int getProgressScaled(int paramInt) {
        return this.progressTicks * paramInt / this.progressMaxTicks;
    }

    public int getBurnTimeRemainingScaled(int paramInt) {
        if (this.fuelMaxBurnTicks == 0) {
            this.fuelMaxBurnTicks = 400;
        }
        return this.fuelBurnTicks * paramInt / this.fuelMaxBurnTicks;
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= this.cost) {
            this.progressMaxTicks = 200 * this.speedMultiplier;
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= this.cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess() && this.progressTicks <= 0) {
            this.progressMaxTicks = 200 * this.speedMultiplier;
            Direction side = Direction.getDirectionFromSide((int)this.getBlockMeta());
            if (this.hasCover(side, DilithiumLensCover.class)) {
                this.progressMaxTicks = (int)Math.ceil((float)this.progressMaxTicks * 1.25f);
            }
            this.progressTicks = this.progressMaxTicks;
            --this.itemContents[0].stackSize;
            if (this.itemContents[0].stackSize <= 0) {
                this.itemContents[0] = null;
            }
        }
    }

    public boolean canProcess() {
        return (this.itemContents[0] != null && this.itemContents[0].getItem().equals(SIItems.dilithiumShard) || this.progressTicks > 0) && (this.fluidContents[0] != null && this.fluidContents[0].amount >= this.cost || this.isBurning()) && this.connectedTo instanceof IStabilizable;
    }

    @Override
    public boolean isBurning() {
        return this.fuelBurnTicks > 0;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putShort("BurnTime", (short)this.fuelBurnTicks);
        tag.putShort("ProcessTime", (short)this.progressTicks);
        tag.putShort("MaxBurnTime", (short)this.fuelMaxBurnTicks);
        tag.putInt("MaxProcessTime", this.progressMaxTicks);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.fuelBurnTicks = tag.getShort("BurnTime");
        this.progressTicks = tag.getShort("ProcessTime");
        this.progressMaxTicks = tag.getInteger("MaxProcessTime");
        this.fuelMaxBurnTicks = tag.getShort("MaxBurnTime");
    }

    @Override
    public boolean isConnected() {
        return this.connectedTo != null;
    }

    @Override
    public TileEntity getConnectedTileEntity() {
        return this.connectedTo;
    }

    @Override
    public boolean connect(TileEntity tileEntity) {
        this.connectedTo = tileEntity;
        return true;
    }

    @Override
    public IOPreview getPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(IOPreview preview) {
        this.preview = preview;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.stabilizer";
    }
}

