/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWrathBeaconBase;
import sunsetsatellite.signalindustries.util.Wave;

public class TileEntityWrathBeacon
extends TileEntityWrathBeaconBase {
    public Random random = new Random();
    public boolean intermission = false;
    public int wave = 0;
    public int currentMaxAmount = 0;
    public boolean started = false;
    public ArrayList<Mob> enemiesLeft = new ArrayList();
    public static ArrayList<Wave> waves = new ArrayList();
    public TickTimer spawnTimer = new TickTimer((Object)this, this::spawn, 20, true);
    public TickTimer intermissionTimer = new TickTimer((Object)this, this::startWave, 300, false);

    public TileEntityWrathBeacon() {
        this.spawnTimer.pause();
        this.intermissionTimer.pause();
        ArrayList<Class<? extends Mob>> mobList = new ArrayList<Class<? extends Mob>>();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        waves.add(new Wave(mobList, 3, 6, 20));
        waves.add(new Wave(mobList, 5, 10, 20));
        waves.add(new Wave(mobList, 6, 12, 20));
        mobList = new ArrayList();
        mobList.add(MobCreeper.class);
        waves.add(new Wave(mobList, 2, 4, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        mobList.add(MobSpider.class);
        waves.add(new Wave(mobList, 8, 10, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        mobList.add(MobSpider.class);
        mobList.add(MobCreeper.class);
        waves.add(new Wave(mobList, 10, 16, 20));
        waves.add(new Wave(mobList, 10, 16, 20));
    }

    public void tick() {
        if (this.worldObj == null) {
            return;
        }
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.active) {
            this.spawnTimer.tick();
            this.intermissionTimer.tick();
        }
        this.enemiesLeft.removeIf(E -> !E.isAlive());
        if (this.active && this.worldObj.getDifficulty() == Difficulty.PEACEFUL) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("The wrath beacon loses all its strength suddenly..");
            }
            this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
        }
        if (this.active && this.started && this.enemiesLeft.isEmpty() && this.wave < 5) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Wave " + this.wave + " complete! Next wave in: " + this.intermissionTimer.max / 20 + "s.");
            }
            this.started = false;
            this.intermissionTimer.unpause();
            this.intermission = true;
            ++this.wave;
        } else if (this.active && this.started && this.enemiesLeft.isEmpty() && this.wave == 5) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Challenge complete!!");
            }
            this.active = false;
            this.started = false;
            this.intermission = false;
            this.spawnTimer.pause();
            this.intermissionTimer.pause();
            this.wave = 0;
            this.currentMaxAmount = 0;
            this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
            this.worldObj.spawnParticle("signalindustries.shockwave", (double)this.x, (double)this.y, (double)this.z, 0.0, 0.0, 0.0, 0);
            EntityItem entityitem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack(SIItems.clearKey, 1));
            this.worldObj.entityJoinedWorld((Entity)entityitem);
        }
        if (this.active) {
            for (float y1 = (float)this.y; y1 < 256.0f; y1 += 0.1f) {
                this.worldObj.spawnParticle("reddust", (double)this.x + 0.5, (double)y1, (double)this.z + 0.5, 0.0, 0.0, 0.0, 0);
            }
        }
        if (this.worldObj != null && this.getBlock() != null) {
            this.tier = ((ITiered)this.getBlock().getLogic()).getTier();
        }
    }

    @Override
    public void activate(Player activator) {
        if (!this.active && this.worldObj != null) {
            if (this.worldObj.getDifficulty() == Difficulty.PEACEFUL) {
                activator.sendMessage("This world is far too peaceful..");
                return;
            }
            if (this.worldObj.isDaytime()) {
                activator.sendMessage("Now is not the time..");
                return;
            }
            if (activator.getHeldItem() != null && activator.getHeldItem().itemID == SIItems.evilEye.id) {
                activator.getHeldItem().consumeItem(activator);
                for (Player player : this.worldObj.players) {
                    if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                    player.sendTranslatedChatMessage("event.signalindustries.wrathBeaconActivated");
                }
                this.active = true;
                this.startWave();
            } else {
                activator.sendMessage("The wrath beacon needs a catalyst..");
            }
        }
    }

    public void startWave() {
        if (this.active && this.worldObj != null) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Wave " + this.wave);
                if (this.wave != 5) continue;
                player.sendMessage("FINAL WAVE!");
            }
            this.intermission = false;
            this.intermissionTimer.pause();
            this.spawnTimer.unpause();
            this.spawnTimer.max = TileEntityWrathBeacon.waves.get((int)this.wave).spawnFrequency;
            this.currentMaxAmount = TileEntityWrathBeacon.waves.get((int)this.wave).lowerBound + this.random.nextInt(TileEntityWrathBeacon.waves.get((int)this.wave).upperBound - TileEntityWrathBeacon.waves.get((int)this.wave).lowerBound);
        }
    }

    public void spawn() {
        if (this.enemiesLeft.size() < this.currentMaxAmount && this.worldObj != null) {
            Mob mob;
            this.started = true;
            ChunkPosition randomPos = this.getRandomSpawningPointInChunk(this.worldObj, this.x, this.z);
            try {
                mob = waves.get(this.wave).chooseRandomMob().getConstructor(World.class).newInstance(this.worldObj);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            mob.setPos((double)randomPos.x, (double)randomPos.y, (double)randomPos.z);
            mob.setRot(this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
            mob.spawnInit();
            this.worldObj.entityJoinedWorld((Entity)mob);
            this.enemiesLeft.add(mob);
        } else {
            this.spawnTimer.pause();
        }
    }

    public ChunkPosition getRandomSpawningPointInChunk(World worldObj, int i, int j) {
        int k = i + worldObj.rand.nextInt(8);
        int l = this.y;
        int i1 = j + worldObj.rand.nextInt(8);
        return new ChunkPosition(k, l, i1);
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

