/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines.multiblocks;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IStabilizable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityStabilizer;

public class TileEntityDimensionalAnchor
extends TileEntityTieredMachineBase
implements IMultiblock,
IStabilizable,
ITileEntityInit {
    public MultiblockInstance multiblock;
    public List<TileEntityStabilizer> stabilizers = new ArrayList<TileEntityStabilizer>();
    public int cost;

    public TileEntityDimensionalAnchor() {
        this.progressMaxTicks = 6000;
        this.cost = 240;
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 8000;
        for (FluidStack ignored : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.itemContents = new ItemStack[1];
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("dimensionalAnchor"));
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("dimensionalAnchor"));
    }

    @Override
    public void tick() {
        if (this.multiblock == null) {
            return;
        }
        this.speedMultiplier = 1.0f;
        this.extractFluids();
        this.stabilizers.clear();
        if (!this.multiblock.isValid()) {
            return;
        }
        Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
        ArrayList tileEntities = this.multiblock.data.getTileEntities(this.worldObj, new Vec3i(this.x, this.y, this.z), dir);
        for (BlockInstance tileEntity : tileEntities) {
            if (!(tileEntity.tile instanceof TileEntityStabilizer)) continue;
            ((TileEntityStabilizer)tileEntity.tile).connectedTo = this;
            this.stabilizers.add((TileEntityStabilizer)tileEntity.tile);
        }
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.itemContents[0] == null) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)(6000.0f / this.speedMultiplier);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess()) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                for (float y1 = (float)this.y; y1 < 256.0f; y1 += 0.1f) {
                }
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
        super.tick();
    }

    public boolean canProcess() {
        if (this.itemContents[0] == null) {
            return false;
        }
        for (TileEntityStabilizer stabilizer : this.stabilizers) {
            if (stabilizer.canProcess()) continue;
            if (this.progressTicks > 0) {
                --this.progressTicks;
            }
            return false;
        }
        return this.itemContents[0].getItem() == SIItems.warpOrb && !this.itemContents[0].getData().containsKey("position");
    }

    public void processItem() {
        if (this.canProcess()) {
            ItemStack stack = this.itemContents[0];
            CompoundTag pos = new CompoundTag();
            pos.putInt("x", this.x);
            pos.putInt("y", this.y + 1);
            pos.putInt("z", this.z);
            stack.getData().put("position", (Tag)pos);
            stack.getData().putInt("dim", this.worldObj.dimension.id);
        }
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= this.cost) {
            this.progressMaxTicks = (int)(6000.0f / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= this.cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    @Override
    public int getProgressScaled(int paramInt) {
        return (int)((double)this.progressTicks / (double)this.progressMaxTicks * (double)paramInt);
    }

    @Override
    public boolean isActive() {
        return this.isBurning();
    }

    @Override
    public boolean isBurning() {
        return super.isBurning() && this.multiblock.isValid();
    }

    @Override
    public boolean isReady() {
        if (this.itemContents[0] == null) {
            return false;
        }
        return this.itemContents[0].getItem() == SIItems.warpOrb && !this.itemContents[0].getData().containsKey("Data");
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.dimensionalAnchor";
    }
}

