/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines.multiblocks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SIWeather;
import sunsetsatellite.signalindustries.entities.MobInfernal;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWrathBeaconBase;
import sunsetsatellite.signalindustries.util.Tier;
import sunsetsatellite.signalindustries.util.Wave;

public class TileEntityReinforcedWrathBeacon
extends TileEntityWrathBeaconBase
implements IMultiblock,
ITileEntityInit {
    public Random random = new Random();
    public MultiblockInstance multiblock;
    public boolean intermission = false;
    public int wave = 0;
    public int currentMaxAmount = 0;
    public boolean started = false;
    public int ticksSinceStart = 0;
    public int enemiesSpawned = 0;
    public boolean suddenDeath = false;
    public ArrayList<Mob> enemiesLeft = new ArrayList();
    public ArrayList<Wave> waves = new ArrayList();
    public Player player;
    public TickTimer spawnTimer = new TickTimer((Object)this, this::spawn, 20, true);
    public TickTimer intermissionTimer = new TickTimer((Object)this, this::startWave, 300, false);
    public TickTimer checkTimer = new TickTimer((Object)this, this::check, 20, true);
    public TickTimer suddenDeathSpawnTImer = new TickTimer((Object)this, this::suddenDeathSpawn, 20, true);

    public TileEntityReinforcedWrathBeacon() {
        this.suddenDeathSpawnTImer.pause();
        this.spawnTimer.pause();
        this.intermissionTimer.pause();
        this.checkTimer.pause();
        this.tier = Tier.REINFORCED;
        ArrayList<Class<? extends Mob>> mobList = new ArrayList<Class<? extends Mob>>();
        mobList.add(MobCreeper.class);
        this.waves.add(new Wave(mobList, 4, 6, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        this.waves.add(new Wave(mobList, 10, 16, 20));
        this.waves.add(new Wave(mobList, 10, 16, 20));
        this.waves.add(new Wave(mobList, 10, 16, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        mobList.add(MobSpider.class);
        this.waves.add(new Wave(mobList, 10, 16, 20));
        mobList = new ArrayList();
        mobList.add(MobCreeper.class);
        mobList.add(MobInfernal.class);
        this.waves.add(new Wave(mobList, 10, 16, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        mobList.add(MobSpider.class);
        this.waves.add(new Wave(mobList, 16, 24, 20));
        this.waves.add(new Wave(mobList, 16, 24, 20));
        mobList = new ArrayList();
        mobList.add(MobZombie.class);
        mobList.add(MobSkeleton.class);
        mobList.add(MobSpider.class);
        mobList.add(MobCreeper.class);
        this.waves.add(new Wave(mobList, 16, 24, 20));
        mobList.add(MobInfernal.class);
        this.waves.add(new Wave(mobList, 20, 32, 20));
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("wrathTree"));
    }

    public void init(Block<?> block) {
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("wrathTree"));
    }

    public void tick() {
        if (this.multiblock == null) {
            return;
        }
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.active) {
            this.spawnTimer.tick();
            this.intermissionTimer.tick();
            this.checkTimer.tick();
            if (this.suddenDeath) {
                this.suddenDeathSpawnTImer.tick();
            }
            ++this.ticksSinceStart;
            if (this.player.getHealth() <= 0) {
                this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
            }
        }
        this.enemiesLeft.removeIf(E -> !E.isAlive());
        if (this.active && this.worldObj.getDifficulty() == Difficulty.PEACEFUL) {
            this.player.sendMessage("The wrath beacon loses all its strength suddenly..");
            this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
            EntityItem entityitem2 = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack(SIBlocks.reinforcedWrathBeacon, 1));
            this.worldObj.entityJoinedWorld((Entity)entityitem2);
        }
        if (this.active && this.started && this.enemiesLeft.isEmpty() && this.enemiesSpawned == this.currentMaxAmount && this.wave < this.waves.size() - 1) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Wave " + this.wave + " complete! Next wave in: " + this.intermissionTimer.max / 20 + "s.");
            }
            this.started = false;
            this.intermissionTimer.unpause();
            this.intermission = true;
            this.enemiesSpawned = 0;
            ++this.wave;
        } else if (this.active && this.started && this.enemiesLeft.isEmpty() && this.enemiesSpawned == this.currentMaxAmount && this.wave == this.waves.size() - 1) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Challenge complete!!");
            }
            for (BlockInstance bi : this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), Direction.Z_POS)) {
                if (this.worldObj.getBlockId(bi.pos.x, bi.pos.y, bi.pos.z) != SIBlocks.fueledEternalTreeLog.id()) continue;
                this.worldObj.setBlockWithNotify(bi.pos.x, bi.pos.y, bi.pos.z, bi.block.id());
            }
            this.active = false;
            this.started = false;
            this.intermission = false;
            this.spawnTimer.pause();
            this.intermissionTimer.pause();
            this.wave = 0;
            this.currentMaxAmount = 0;
            this.enemiesSpawned = 0;
            this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
            this.worldObj.spawnParticle("signalindustries.shockwave", (double)this.x, (double)this.y, (double)this.z, 0.0, 0.0, 0.0, 0);
            EntityItem entityitem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack(SIItems.saturatedKey, 1));
            EntityItem entityitem2 = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack(SIBlocks.reinforcedWrathBeacon, 1));
            this.worldObj.entityJoinedWorld((Entity)entityitem);
            this.worldObj.entityJoinedWorld((Entity)entityitem2);
        }
        if (!this.suddenDeath && this.active && this.ticksSinceStart % 30 == 0) {
            ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), Direction.Z_POS);
            int i = this.random.nextInt(blocks.size());
            BlockInstance block = (BlockInstance)blocks.get(i);
            while (this.worldObj.getBlockId(block.pos.x, block.pos.y, block.pos.z) == SIBlocks.fueledEternalTreeLog.id() && !this.readyForSuddenDeath()) {
                i = this.random.nextInt(blocks.size());
                block = (BlockInstance)blocks.get(i);
            }
            this.worldObj.setBlockWithNotify(block.pos.x, block.pos.y, block.pos.z, SIBlocks.fueledEternalTreeLog.id());
        }
        if (this.worldObj != null && this.getBlock() != null) {
            this.tier = ((ITiered)this.getBlock().getLogic()).getTier();
        }
    }

    public void check() {
        if (this.getBlock() != null && this.active) {
            if (this.worldObj != null && this.worldObj.getCurrentWeather() == SIWeather.weatherBloodMoon && !this.suddenDeath) {
                for (BlockInstance bi : this.multiblock.data.getSubstitutions(new Vec3i(this.x, this.y, this.z), Direction.Z_POS)) {
                    if (this.worldObj.getBlockId(bi.pos.x, bi.pos.y, bi.pos.z) != SIBlocks.eternalTreeLog.id()) continue;
                    this.worldObj.setBlockWithNotify(bi.pos.x, bi.pos.y, bi.pos.z, bi.block.id());
                }
            }
            if (!this.suddenDeath && this.readyForSuddenDeath()) {
                this.suddenDeath = true;
                this.suddenDeathSpawnTImer.unpause();
                this.player.sendMessage("Time has ran out... Brace yourself!");
            }
            if (!this.multiblock.isValid() && this.worldObj != null) {
                this.player.sendMessage("The wrath beacon loses all its strength suddenly..");
                this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
                EntityItem entityitem2 = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack(SIBlocks.reinforcedWrathBeacon, 1));
                this.worldObj.entityJoinedWorld((Entity)entityitem2);
            }
        }
    }

    @Override
    public void activate(Player activator) {
        if (!this.active && this.worldObj != null) {
            if (this.worldObj.getDifficulty() == Difficulty.PEACEFUL) {
                this.player.sendMessage("This world is far too peaceful..");
                return;
            }
            if (this.worldObj.isDaytime()) {
                this.player.sendMessage("Now is not the time..");
                return;
            }
            if (!this.multiblock.isValid()) {
                this.player.sendTranslatedChatMessage("event.signalindustries.invalidMultiblock");
                return;
            }
            if (this.player.inventory.getCurrentItem() != null && this.player.inventory.getCurrentItem().getItem().id == SIItems.infernalEye.id) {
                this.player.inventory.getCurrentItem().consumeItem(this.player);
                for (Player player : this.worldObj.players) {
                    if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                    player.sendTranslatedChatMessage("event.signalindustries.reinforcedWrathBeaconActivated");
                }
                this.active = true;
                this.player = activator;
                this.checkTimer.unpause();
                this.startWave();
            } else {
                this.player.sendMessage("The wrath beacon needs a catalyst..");
            }
        }
    }

    public void suddenDeathSpawn() {
        if (this.suddenDeath) {
            if (this.getBlock() != null) {
                Mob mob;
                this.started = true;
                ChunkPosition randomPos = this.getRandomSpawningPointInChunk(this.worldObj, this.x, this.z);
                try {
                    mob = this.waves.get(this.wave).chooseRandomMob().getConstructor(World.class).newInstance(this.worldObj);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                mob.setPos((double)randomPos.x, (double)randomPos.y, (double)randomPos.z);
                mob.setRot(this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                mob.spawnInit();
                this.worldObj.entityJoinedWorld((Entity)mob);
                if (mob instanceof MobInfernal) {
                    ((MobInfernal)mob).eclipseImmune = true;
                }
            } else {
                this.suddenDeathSpawnTImer.pause();
            }
        } else {
            this.suddenDeathSpawnTImer.pause();
        }
    }

    public void startWave() {
        if (this.active && this.worldObj != null) {
            for (Player player : this.worldObj.players) {
                if (player.distanceToSqr((double)this.x, (double)this.y, (double)this.z) > 64.0) continue;
                player.sendMessage("Wave " + this.wave);
                if (this.wave != this.waves.size() - 1) continue;
                player.sendMessage("FINAL WAVE!");
            }
            this.intermission = false;
            this.intermissionTimer.pause();
            this.spawnTimer.unpause();
            this.spawnTimer.max = this.waves.get((int)this.wave).spawnFrequency;
            int diff = this.waves.get((int)this.wave).upperBound - this.waves.get((int)this.wave).lowerBound;
            this.currentMaxAmount = diff > 0 ? this.waves.get((int)this.wave).lowerBound + this.random.nextInt(diff) : this.waves.get((int)this.wave).lowerBound;
        }
    }

    public void spawn() {
        if (this.getBlock() != null) {
            if (this.enemiesSpawned < this.currentMaxAmount) {
                Mob mob;
                this.started = true;
                ChunkPosition randomPos = this.getRandomSpawningPointInChunk(this.worldObj, this.x, this.z);
                try {
                    mob = this.waves.get(this.wave).chooseRandomMob().getConstructor(World.class).newInstance(this.worldObj);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                mob.setPos((double)randomPos.x, (double)randomPos.y, (double)randomPos.z);
                mob.setRot(this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                mob.spawnInit();
                this.worldObj.entityJoinedWorld((Entity)mob);
                this.enemiesLeft.add(mob);
                if (mob instanceof MobInfernal) {
                    ((MobInfernal)mob).eclipseImmune = true;
                }
                ++this.enemiesSpawned;
            } else {
                this.spawnTimer.pause();
            }
        }
    }

    public ChunkPosition getRandomSpawningPointInChunk(World worldObj, int i, int j) {
        int k = i - 8 + worldObj.rand.nextInt(16);
        int l = this.y;
        int i1 = j - 8 + worldObj.rand.nextInt(16);
        return new ChunkPosition(k, l, i1);
    }

    public boolean readyForSuddenDeath() {
        for (BlockInstance substitution : this.multiblock.data.getSubstitutions(new Vec3i(this.x, this.y, this.z), Direction.Z_POS)) {
            if (this.worldObj.getBlockId(substitution.pos.x, substitution.pos.y, substitution.pos.z) == SIBlocks.fueledEternalTreeLog.id()) continue;
            return false;
        }
        return true;
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

