/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines.multiblocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.interfaces.IActiveForm;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.interfaces.IStabilizable;
import sunsetsatellite.signalindustries.items.tools.ItemFuelCell;
import sunsetsatellite.signalindustries.tiles.TileEntityEnergyConnector;
import sunsetsatellite.signalindustries.tiles.TileEntityIgnitor;
import sunsetsatellite.signalindustries.tiles.TileEntityItemBus;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTiered;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityStabilizer;

public class TileEntitySignalumReactor
extends TileEntityTiered
implements IMultiblock,
IStabilizable,
IActiveForm,
ITileEntityInit {
    public MultiblockInstance multiblock;
    public List<TileEntityStabilizer> stabilizers = new ArrayList<TileEntityStabilizer>();
    public List<TileEntityIgnitor> ignitors = new ArrayList<TileEntityIgnitor>();
    public TileEntityEnergyConnector connector;
    public TileEntityItemBus input;
    public TileEntityItemBus output;
    public State state = State.INACTIVE;
    public int stabilityField = 0;
    public int maxStabilityField = 100;

    public TileEntitySignalumReactor() {
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("signalumReactor"));
    }

    public void init(Block<?> block) {
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("signalumReactor"));
    }

    @Override
    public boolean isActive() {
        return this.state == State.RUNNING;
    }

    @Override
    public boolean isReady() {
        return this.state == State.IGNITING;
    }

    @Override
    public boolean isBurning() {
        return this.isActive();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public void tick() {
        if (this.multiblock == null) {
            return;
        }
        super.tick();
        this.stabilizers.clear();
        this.ignitors.clear();
        if (!this.multiblock.isValid()) {
            this.state = State.INACTIVE;
            return;
        }
        Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
        ArrayList tileEntities = this.multiblock.data.getTileEntities(this.worldObj, new Vec3i(this.x, this.y, this.z), dir);
        for (BlockInstance tileEntity : tileEntities) {
            if (!(tileEntity.tile instanceof IMultiblockPart)) continue;
            if (tileEntity.tile instanceof TileEntityStabilizer) {
                this.stabilizers.add((TileEntityStabilizer)tileEntity.tile);
            } else if (tileEntity.tile instanceof TileEntityIgnitor) {
                this.ignitors.add((TileEntityIgnitor)tileEntity.tile);
            } else if (tileEntity.tile instanceof TileEntityItemBus) {
                if (tileEntity.block == SIBlocks.reinforcedItemInputBus) {
                    this.input = (TileEntityItemBus)tileEntity.tile;
                } else if (tileEntity.block == SIBlocks.reinforcedItemOutputBus) {
                    this.output = (TileEntityItemBus)tileEntity.tile;
                }
            } else if (tileEntity.tile instanceof TileEntityEnergyConnector) {
                this.connector = (TileEntityEnergyConnector)tileEntity.tile;
            }
            ((IMultiblockPart)tileEntity.tile).connect(this);
        }
        if (this.state == State.IGNITING && this.checkIfIgnitorsReady() && this.checkIfStabilizersReady()) {
            this.state = State.RUNNING;
        }
        if (this.state == State.RUNNING && this.checkIfStabilizersReady() && this.getFuel() > 0) {
            this.depleteRandomFuelCell();
        } else if (this.state == State.RUNNING) {
            this.state = State.INACTIVE;
        }
        if (this.state == State.RUNNING) {
            ItemStack[] itemContents = this.input.itemContents;
            for (int i = 0; i < itemContents.length; ++i) {
                ItemStack stack = itemContents[i];
                if (stack == null || !(stack.getItem() instanceof ItemFuelCell) || stack.getData().getInteger("fuel") > 0 || this.output.itemContents[i] != null) continue;
                this.output.itemContents[i] = stack;
                this.input.itemContents[i] = null;
            }
            if (this.getFuel() <= 0) {
                this.state = State.INACTIVE;
            }
            for (TileEntityIgnitor ignitor : this.ignitors) {
                if (ignitor.isEmpty()) {
                    this.state = State.INACTIVE;
                    break;
                }
                ignitor.isActivated = true;
            }
        } else {
            for (TileEntityIgnitor ignitor : this.ignitors) {
                ignitor.isActivated = false;
            }
        }
    }

    public void depleteRandomFuelCell() {
        Random random = new Random();
        if ((double)random.nextFloat() <= 1.25) {
            for (ItemStack stack : this.input.itemContents) {
                if (stack == null || !(stack.getItem() instanceof ItemFuelCell)) continue;
                int fuel = stack.getData().getInteger("fuel");
                int depleted = stack.getData().getInteger("depleted");
                if (fuel < 0) continue;
                stack.getData().putInt("fuel", fuel - 1);
                stack.getData().putInt("depleted", depleted + 1);
            }
        }
    }

    public boolean checkIfIgnitorsReady() {
        for (TileEntityIgnitor ignitor : this.ignitors) {
            if (ignitor.isReady()) continue;
            return false;
        }
        return true;
    }

    public boolean checkIfStabilizersReady() {
        boolean ready = true;
        for (TileEntityStabilizer stabilizer : this.stabilizers) {
            if (stabilizer.canProcess()) continue;
            ready = false;
        }
        return ready;
    }

    public int getFuel() {
        if (this.input == null) {
            return 0;
        }
        int fuel = 0;
        for (ItemStack stack : this.input.itemContents) {
            if (stack == null || !(stack.getItem() instanceof ItemFuelCell)) continue;
            fuel += stack.getData().getInteger("fuel");
        }
        return fuel;
    }

    public int getDepletedFuel() {
        if (this.input == null) {
            return 0;
        }
        int depleted = 0;
        for (ItemStack stack : this.input.itemContents) {
            if (stack == null || !(stack.getItem() instanceof ItemFuelCell)) continue;
            depleted += stack.getData().getInteger("depleted");
        }
        return depleted;
    }

    public void start() {
        if (this.getFuel() > 0 && this.state == State.INACTIVE) {
            this.state = State.IGNITING;
        } else if (this.state == State.IGNITING || this.state == State.RUNNING) {
            this.state = State.INACTIVE;
        }
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    public Vec3i getPosition() {
        return new Vec3i(this.x, this.y, this.z);
    }

    public static enum State {
        INACTIVE,
        IGNITING,
        RUNNING;

    }
}

