/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.util;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SIBlocks;

public class MeteorLocation {
    public final Type type;
    public final Vec3i location;

    public MeteorLocation(Type type, Vec3i location) {
        this.type = type;
        this.location = location;
    }

    public void write(CompoundTag tag) {
        tag.putInt("x", this.location.x);
        tag.putInt("y", this.location.y);
        tag.putInt("z", this.location.z);
        tag.putString("type", this.type.name());
    }

    public static MeteorLocation read(CompoundTag tag) {
        Vec3i location = new Vec3i(tag.getInteger("x"), tag.getInteger("y"), tag.getInteger("z"));
        Type type = Type.valueOf(tag.getString("type"));
        return new MeteorLocation(type, location);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeteorLocation)) {
            return false;
        }
        MeteorLocation that = (MeteorLocation)o;
        return this.type == that.type && this.location.equals((Object)that.location);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.location.hashCode();
        return result;
    }

    public static enum Type {
        IRON,
        SIGNALUM,
        DILITHIUM,
        UNKNOWN;


        public static Type getFromBlock(Block<?> block) {
            if (block == SIBlocks.signalumOre) {
                return SIGNALUM;
            }
            if (block == SIBlocks.dilithiumOre) {
                return DILITHIUM;
            }
            if (block == Blocks.ORE_IRON_BASALT) {
                return IRON;
            }
            return UNKNOWN;
        }
    }
}

