/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.worldgen;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.util.ExplosionNoDrops;
import sunsetsatellite.signalindustries.util.MeteorLocation;

public class WorldFeatureMeteor
extends WorldFeature {
    public int oreId;
    public int oreMeta;
    public int oreChance;
    public int radius = 4;

    public WorldFeatureMeteor(int oreId, int oreMeta, int oreChance) {
        this.oreId = oreId;
        this.oreMeta = oreMeta;
        this.oreChance = oreChance;
    }

    public WorldFeatureMeteor(int oreId, int oreMeta, int oreChance, int radius) {
        this.oreId = oreId;
        this.oreMeta = oreMeta;
        this.oreChance = oreChance;
        this.radius = radius;
    }

    public boolean place(World world, Random random, int i, int j, int k) {
        SignalIndustries.LOGGER.info("{} Meteor fell at X:{} Y:{} Z:{}", new Object[]{I18n.getInstance().translateNameKey(Blocks.blocksList[this.oreId].getLanguageKey(this.oreMeta)), i, j, k});
        ExplosionNoDrops ex = new ExplosionNoDrops(world, null, i, j, k, 50.0f);
        ex.explode();
        ex.addEffects(false);
        int oreBlocks = 0;
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    if (!this.isPointInsideSphere(x, y, z, this.radius)) continue;
                    if (this.oreId != 0 && random.nextInt(100) < this.oreChance) {
                        world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, this.oreId, this.oreMeta);
                        ++oreBlocks;
                        continue;
                    }
                    world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, Blocks.BASALT.id(), 0);
                }
            }
        }
        SignalIndustries.addMeteorLocation(new MeteorLocation(MeteorLocation.Type.getFromBlock(Blocks.blocksList[this.oreId]), new Vec3i(i, j, k)));
        SignalIndustries.LOGGER.info("Meteor contains {} ore.", (Object)oreBlocks);
        return true;
    }

    public boolean isPointInsideSphere(int x, int y, int z, double radius) {
        return (double)(x * x + y * y + z * z) < radius * radius;
    }
}

