/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.tmb.category;

import java.util.List;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.ExtendedIngredientList;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.ExtendedTypedIngredient;
import sunsetsatellite.catalyst.fluids.api.impl.tmb.TMBFluidPlugin;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.api.impl.tmb.MachineRecipeTranslator;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachine;
import sunsetsatellite.signalindustries.util.RecipeProperties;
import turing.tmb.RecipeLayoutBuilder;
import turing.tmb.TypedIngredient;
import turing.tmb.api.ItemStackIngredientRenderer;
import turing.tmb.api.VanillaTypes;
import turing.tmb.api.drawable.IDrawable;
import turing.tmb.api.drawable.IDrawableAnimated;
import turing.tmb.api.drawable.IDrawableStatic;
import turing.tmb.api.drawable.IIngredientList;
import turing.tmb.api.ingredient.IIngredientRenderer;
import turing.tmb.api.ingredient.IIngredientType;
import turing.tmb.api.ingredient.ITypedIngredient;
import turing.tmb.api.recipe.ILookupContext;
import turing.tmb.api.recipe.IRecipeCategory;
import turing.tmb.api.recipe.IRecipeLayout;
import turing.tmb.api.recipe.RecipeIngredientRole;
import turing.tmb.api.runtime.ITMBRuntime;
import turing.tmb.client.DrawableAnimated;
import turing.tmb.client.DrawableBlank;
import turing.tmb.client.DrawableIngredient;
import turing.tmb.client.DrawableTexture;
import turing.tmb.util.IngredientList;

public class CentrifugeRecipeCategory
implements IRecipeCategory<MachineRecipeTranslator> {
    private final IDrawable background = new DrawableBlank(120, 80);
    private final IDrawable icon = new DrawableIngredient((Object)SIBlocks.reinforcedCentrifuge.getDefaultStack(), (IIngredientRenderer)ItemStackIngredientRenderer.INSTANCE);
    private final IDrawable arrow = new DrawableAnimated((IDrawableStatic)new DrawableTexture("/assets/tmb/textures/gui/gui_vanilla.png", 82, 128, 24, 16, 0, 0, 0, 0, 24, 16), 1, IDrawableAnimated.StartDirection.LEFT, false);
    private final IDrawable arrowBack = new DrawableTexture("/assets/tmb/textures/gui/gui_vanilla.png", 24, 133, 24, 16, 0, 0, 0, 0, 24, 16);
    private final int x = 54;

    public String getName() {
        return "Centrifuge";
    }

    public String getNamespace() {
        return "signalindustries";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawRecipe(ITMBRuntime runtime, MachineRecipeTranslator recipe, IRecipeLayout layout, List<IIngredientList> ingredients, ILookupContext context) {
        RecipeProperties data = (RecipeProperties)((RecipeEntryMachine)((Object)recipe.getOriginal())).getData();
        this.getIngredients(recipe, layout, context, ingredients);
        if (data.thisTierOnly) {
            runtime.getGuiHelper().getMinecraft().font.drawStringWithShadow("Only at: " + data.tier.getTextColor() + data.tier.getRank() + TextFormatting.WHITE, 24, this.background.getHeight(), -986896);
        } else {
            runtime.getGuiHelper().getMinecraft().font.drawStringWithShadow("Minimum tier: " + data.tier.getTextColor() + data.tier.getRank() + TextFormatting.WHITE, 24, this.background.getHeight(), -986896);
        }
        this.arrowBack.draw(runtime.getGuiHelper(), 100, this.background.getHeight() / 2 - 5);
        this.arrow.draw(runtime.getGuiHelper(), 100, this.background.getHeight() / 2 - 5);
        runtime.getGuiHelper().getMinecraft().font.drawCenteredString(data.ticks + "t", 113, this.background.getHeight() / 2 - 14, -1);
        runtime.getGuiHelper().getMinecraft().font.drawCenteredString(data.chance * 100.0f + "%", 113, this.background.getHeight() / 2 + 14, -1);
    }

    public void getIngredients(MachineRecipeTranslator recipe, IRecipeLayout layout, ILookupContext context, List<IIngredientList> ingredients) {
        RecipeProperties data = (RecipeProperties)((RecipeEntryMachine)((Object)recipe.getOriginal())).getData();
        RecipeExtendedSymbol[] input = (RecipeExtendedSymbol[])((RecipeEntryMachine)((Object)recipe.getOriginal())).getInput();
        for (int i = 0; i < 4; ++i) {
            if (i >= input.length) {
                ingredients.add(i, (IIngredientList)ExtendedIngredientList.fromRecipeSymbol(null));
                continue;
            }
            RecipeExtendedSymbol symbol = input[i];
            ingredients.add(i, (IIngredientList)ExtendedIngredientList.fromRecipeSymbol((RecipeExtendedSymbol)symbol));
        }
        ingredients.add(4, (IIngredientList)new IngredientList(new ITypedIngredient[]{TypedIngredient.itemStackIngredient((ItemStack)((ItemStack)((RecipeEntryMachine)((Object)recipe.getOriginal())).getOutput()))}));
        ingredients.add(5, (IIngredientList)new IngredientList(new ITypedIngredient[]{ExtendedTypedIngredient.fluidStackIngredient((FluidStack)new FluidStack(SIFluids.ENERGY, (int)((float)data.cost * ((float)data.ticks / 200.0f))))}));
    }

    public IRecipeLayout getRecipeLayout() {
        return new RecipeLayoutBuilder().addInputSlot(0, (IIngredientType)TMBFluidPlugin.FLUID_STACK).setPosition(34, this.background.getHeight() / 2 - 6).build().addInputSlot(1, (IIngredientType)TMBFluidPlugin.FLUID_STACK).setPosition(54, this.background.getHeight() / 2 + 16).build().addInputSlot(2, (IIngredientType)TMBFluidPlugin.FLUID_STACK).setPosition(54, this.background.getHeight() / 2 - 26).build().addInputSlot(3, (IIngredientType)TMBFluidPlugin.FLUID_STACK).setPosition(74, this.background.getHeight() / 2 - 6).build().addOutputSlot(4, (IIngredientType)VanillaTypes.ITEM_STACK).setPosition(130, this.background.getHeight() / 2 - 6).build().addSlot(5, (IIngredientType)TMBFluidPlugin.FLUID_STACK, RecipeIngredientRole.RENDER_ONLY).setPosition(10, this.background.getHeight() / 2 - 6).build().build();
    }
}

