/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicMachine;
import sunsetsatellite.signalindustries.tiles.TileEntityExternalIO;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockModelExternalIO
extends BlockModelStandard<BlockLogicMachine> {
    public IconCoordinate input = TextureRegistry.getTexture((String)"signalindustries:block/external_io_input");
    public IconCoordinate output = TextureRegistry.getTexture((String)"signalindustries:block/external_io_output");
    public IconCoordinate both = TextureRegistry.getTexture((String)"signalindustries:block/external_io_both");
    public IconCoordinate blank = TextureRegistry.getTexture((String)"signalindustries:block/external_io_blank");
    public IconCoordinate reinforcedInput = TextureRegistry.getTexture((String)"signalindustries:block/reinforced_external_io_input");
    public IconCoordinate reinforcedOutput = TextureRegistry.getTexture((String)"signalindustries:block/reinforced_external_io_output");
    public IconCoordinate reinforcedBoth = TextureRegistry.getTexture((String)"signalindustries:block/reinforced_external_io_both");
    public IconCoordinate reinforcedBlank = TextureRegistry.getTexture((String)"signalindustries:block/reinforced_external_io_blank");

    public BlockModelExternalIO(Block<BlockLogicMachine> block) {
        super(block);
        if (((BlockLogicMachine)block.getLogic()).tier == Tier.BASIC) {
            this.setTex(0, this.blank, new Side[]{Side.TOP});
            this.setTex(0, this.blank, new Side[]{Side.BOTTOM});
            this.setTex(0, this.blank, new Side[]{Side.NORTH});
            this.setTex(0, this.blank, new Side[]{Side.SOUTH});
            this.setTex(0, this.blank, new Side[]{Side.EAST});
            this.setTex(0, this.blank, new Side[]{Side.WEST});
        } else {
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.TOP});
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.BOTTOM});
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.NORTH});
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.SOUTH});
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.EAST});
            this.setTex(0, this.reinforcedBlank, new Side[]{Side.WEST});
        }
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        TileEntityExternalIO tile = (TileEntityExternalIO)blockAccess.getTileEntity(x, y, z);
        Connection connection = (Connection)tile.itemConnections.get(Direction.getDirectionFromSide((int)side.getId()));
        if (((BlockLogicMachine)this.block.getLogic()).tier == Tier.BASIC) {
            if (connection == Connection.INPUT) {
                return this.input;
            }
            if (connection == Connection.OUTPUT) {
                return this.output;
            }
            if (connection == Connection.BOTH) {
                return this.both;
            }
            return this.blank;
        }
        if (((BlockLogicMachine)this.block.getLogic()).tier == Tier.REINFORCED) {
            if (connection == Connection.INPUT) {
                return this.reinforcedInput;
            }
            if (connection == Connection.OUTPUT) {
                return this.reinforcedOutput;
            }
            if (connection == Connection.BOTH) {
                return this.reinforcedBoth;
            }
            return this.reinforcedBlank;
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }
}

