/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.io.IFluidIO;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.util.IOPreview;

public class BlockModelIOPreview
extends BlockModelStandard<BlockLogic> {
    public IconCoordinate input = TextureRegistry.getTexture((String)"signalindustries:block/input_overlay");
    public IconCoordinate output = TextureRegistry.getTexture((String)"signalindustries:block/output_overlay");
    public IconCoordinate both = TextureRegistry.getTexture((String)"signalindustries:block/both_io_overlay");

    public BlockModelIOPreview(Block<? extends BlockLogic> block) {
        super(block);
    }

    public boolean hasOverbright() {
        return true;
    }

    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        TileEntity tileEntity = blockAccess.getTileEntity(x, y, z);
        if (tileEntity instanceof IHasIOPreview && ((IHasIOPreview)tileEntity).getPreview() != IOPreview.NONE) {
            switch (((IHasIOPreview)tileEntity).getPreview()) {
                case ITEM: {
                    if (!(tileEntity instanceof IItemIO)) break;
                    Connection io = ((IItemIO)tileEntity).getItemIOForSide(Direction.getDirectionFromSide((int)side));
                    switch (io) {
                        case INPUT: {
                            return this.input;
                        }
                        case OUTPUT: {
                            return this.output;
                        }
                        case BOTH: {
                            return this.both;
                        }
                        case NONE: {
                            return null;
                        }
                    }
                    break;
                }
                case FLUID: {
                    if (!(tileEntity instanceof IFluidIO)) break;
                    Connection io = ((IFluidIO)tileEntity).getFluidIOForSide(Direction.getDirectionFromSide((int)side));
                    switch (io) {
                        case INPUT: {
                            return this.input;
                        }
                        case OUTPUT: {
                            return this.output;
                        }
                        case BOTH: {
                            return this.both;
                        }
                        case NONE: {
                            return null;
                        }
                    }
                }
            }
        }
        return null;
    }
}

