/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import java.util.HashMap;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicMachine;
import sunsetsatellite.signalindustries.tiles.TileEntityIgnitor;

public class BlockModelIgnitor
extends BlockModelStandard<BlockLogicMachine> {
    protected HashMap<Side, IconCoordinate> defaultTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> readyTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> activeTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> invertedDefaultTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> invertedReadyTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> invertedActiveTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> readyOverbrightTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> activeOverbrightTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> invertedReadyOverbrightTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));
    protected HashMap<Side, IconCoordinate> invertedActiveOverbrightTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((IconCoordinate[])Catalyst.arrayFill((Object[])new IconCoordinate[Side.values().length], (Object)BLOCK_TEXTURE_UNASSIGNED)));

    public BlockModelIgnitor(Block<?> block) {
        super(block);
        this.defaultTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_inactive"));
        this.defaultTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_inactive"));
        this.defaultTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive"));
        this.defaultTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive"));
        this.defaultTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive"));
        this.defaultTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive"));
        this.invertedDefaultTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_inactive"));
        this.invertedDefaultTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_inactive"));
        this.invertedDefaultTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive_inverted"));
        this.invertedDefaultTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive_inverted"));
        this.invertedDefaultTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive_inverted"));
        this.invertedDefaultTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_inactive_inverted"));
        this.readyTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_ready"));
        this.readyTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_ready"));
        this.readyTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready"));
        this.readyTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready"));
        this.readyTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready"));
        this.readyTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready"));
        this.activeTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_active"));
        this.activeTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_active"));
        this.activeTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active"));
        this.activeTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active"));
        this.activeTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active"));
        this.activeTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active"));
        this.invertedReadyTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_ready"));
        this.invertedReadyTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_ready"));
        this.invertedReadyTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready_inverted"));
        this.invertedReadyTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready_inverted"));
        this.invertedReadyTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready_inverted"));
        this.invertedReadyTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_ready_inverted"));
        this.invertedActiveTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_bottom_active"));
        this.invertedActiveTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_top_active"));
        this.invertedActiveTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active_inverted"));
        this.invertedActiveTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active_inverted"));
        this.invertedActiveTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active_inverted"));
        this.invertedActiveTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/reinforced_ignitor_active_inverted"));
        this.readyOverbrightTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_8_overlay"));
        this.readyOverbrightTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_4_overlay"));
        this.readyOverbrightTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_5_overlay"));
        this.readyOverbrightTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_5_overlay"));
        this.readyOverbrightTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_5_overlay"));
        this.readyOverbrightTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_5_overlay"));
        this.activeOverbrightTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_7_overlay"));
        this.activeOverbrightTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_3_overlay"));
        this.activeOverbrightTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_1_overlay"));
        this.activeOverbrightTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_1_overlay"));
        this.activeOverbrightTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_1_overlay"));
        this.activeOverbrightTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_1_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_4_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_8_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_6_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_6_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_6_overlay"));
        this.invertedReadyOverbrightTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_6_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.TOP, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_3_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.BOTTOM, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_7_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.NORTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_2_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.SOUTH, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_2_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.EAST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_2_overlay"));
        this.invertedActiveOverbrightTextures.put(Side.WEST, TextureRegistry.getTexture((String)"signalindustries:block/ignitor_2_overlay"));
        this.setTex(0, this.defaultTextures.get(Side.TOP), new Side[]{Side.TOP});
        this.setTex(0, this.defaultTextures.get(Side.BOTTOM), new Side[]{Side.BOTTOM});
        this.setTex(0, this.defaultTextures.get(Side.NORTH), new Side[]{Side.NORTH});
        this.setTex(0, this.defaultTextures.get(Side.SOUTH), new Side[]{Side.SOUTH});
        this.setTex(0, this.defaultTextures.get(Side.EAST), new Side[]{Side.EAST});
        this.setTex(0, this.defaultTextures.get(Side.WEST), new Side[]{Side.WEST});
    }

    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int sideId) {
        Side side = Side.getSideById((int)sideId);
        TileEntity tile = blockAccess.getTileEntity(x, y, z);
        int meta = blockAccess.getBlockMetadata(x, y - 1, z);
        if (tile == null) {
            return null;
        }
        if (tile instanceof TileEntityIgnitor) {
            TileEntityIgnitor ignitor = (TileEntityIgnitor)tile;
            if (ignitor.isBurning()) {
                if (meta == 0 && blockAccess.getBlockId(x, y - 1, z) == SIBlocks.reinforcedIgnitor.id()) {
                    return this.invertedActiveOverbrightTextures.get(side);
                }
                return this.activeOverbrightTextures.get(side);
            }
            if (ignitor.isReady()) {
                if (meta == 0 && blockAccess.getBlockId(x, y - 1, z) == SIBlocks.reinforcedIgnitor.id()) {
                    return this.invertedReadyOverbrightTextures.get(side);
                }
                return this.readyOverbrightTextures.get(side);
            }
        }
        return null;
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        TileEntity tile = blockAccess.getTileEntity(x, y, z);
        int meta = blockAccess.getBlockMetadata(x, y - 1, z);
        if (tile == null) {
            return this.defaultTextures.get(side);
        }
        if (tile instanceof TileEntityIgnitor) {
            TileEntityIgnitor ignitor = (TileEntityIgnitor)tile;
            if (ignitor.isBurning()) {
                if (meta == 0 && blockAccess.getBlockId(x, y - 1, z) == SIBlocks.reinforcedIgnitor.id()) {
                    return this.invertedActiveTextures.get(side);
                }
                return this.activeTextures.get(side);
            }
            if (ignitor.isReady()) {
                if (meta == 0 && blockAccess.getBlockId(x, y - 1, z) == SIBlocks.reinforcedIgnitor.id()) {
                    return this.invertedReadyTextures.get(side);
                }
                return this.readyTextures.get(side);
            }
            if (meta == 0 && blockAccess.getBlockId(x, y - 1, z) == SIBlocks.reinforcedIgnitor.id()) {
                return this.invertedDefaultTextures.get(side);
            }
            return this.defaultTextures.get(side);
        }
        return this.defaultTextures.get(side);
    }
}

