/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.covers;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.catalyst.core.util.io.InventoryWrapper;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.interfaces.IAcceptsCovers;
import sunsetsatellite.signalindustries.items.covers.ItemCover;

public class ConveyorCover
extends CoverBase {
    protected final String texture = "signalindustries:block/conveyor_cover";
    public int externalActiveSlot = 0;

    @Override
    public void openConfiguration(Player player, Direction dir) {
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @Override
    public void tick() {
        if (this.machine instanceof Container && this.machine instanceof TileEntity && this.machine instanceof IItemIO) {
            TileEntity tile = (TileEntity)this.machine;
            InventoryWrapper inv = new InventoryWrapper((Container)this.machine);
            IItemIO io = (IItemIO)this.machine;
            Connection con = io.getItemIOForSide(this.dir);
            int activeSlot = io.getActiveItemSlotForSide(this.dir);
            TileEntity otherTile = this.dir.getTileEntity((WorldSource)tile.worldObj, tile);
            if (activeSlot == -1 || con == Connection.NONE) {
                return;
            }
            if (otherTile instanceof Container && otherTile instanceof IItemIO) {
                InventoryWrapper otherInv = new InventoryWrapper((Container)otherTile);
                IItemIO otherIo = (IItemIO)otherTile;
                Connection otherCon = otherIo.getItemIOForSide(this.dir.getOpposite());
                int otherActiveSlot = otherIo.getActiveItemSlotForSide(this.dir.getOpposite());
                if (otherActiveSlot == -1 || otherCon == Connection.NONE) {
                    return;
                }
                if (con == Connection.INPUT && otherCon == Connection.OUTPUT) {
                    Optional<ItemStack> stack = Optional.ofNullable(otherInv.remove(otherActiveSlot, false, false));
                    AtomicReference leftovers = new AtomicReference(Optional.empty());
                    stack.ifPresent(S -> leftovers.set(Optional.ofNullable(inv.add(S))));
                    leftovers.get().ifPresent(S -> otherInv.add(otherActiveSlot, S));
                } else if (con == Connection.OUTPUT && otherCon == Connection.INPUT) {
                    Optional<ItemStack> stack = Optional.ofNullable(inv.remove(activeSlot, false, false));
                    AtomicReference leftovers = new AtomicReference(Optional.empty());
                    stack.ifPresent(S -> leftovers.set(Optional.ofNullable(otherInv.add(otherActiveSlot, S))));
                    leftovers.get().ifPresent(S -> inv.add(activeSlot, S));
                }
            } else if (otherTile instanceof Container) {
                InventoryWrapper otherInv = new InventoryWrapper((Container)otherTile);
                if (con == Connection.INPUT) {
                    Optional<ItemStack> stack = Optional.ofNullable(otherInv.remove(this.externalActiveSlot, false, false));
                    AtomicReference leftovers = new AtomicReference(Optional.empty());
                    stack.ifPresent(S -> leftovers.set(Optional.ofNullable(inv.add(activeSlot, S))));
                    leftovers.get().ifPresent(S -> otherInv.add(this.externalActiveSlot, S));
                } else if (con == Connection.OUTPUT) {
                    Optional<ItemStack> stack = Optional.ofNullable(inv.remove(activeSlot, false, false));
                    AtomicReference leftovers = new AtomicReference(Optional.empty());
                    stack.ifPresent(S -> leftovers.set(Optional.ofNullable(otherInv.add(this.externalActiveSlot, S))));
                    leftovers.get().ifPresent(S -> inv.add(activeSlot, S));
                }
            }
        }
    }

    @Override
    public String getTexture() {
        return "signalindustries:block/conveyor_cover";
    }

    @Override
    public ItemCover getItem() {
        return SIItems.conveyorCover;
    }

    @Override
    public void onInstalled(Direction dir, IAcceptsCovers machine, Player player) {
        player.sendMessage("Cover installed!");
        super.onInstalled(dir, machine, player);
    }

    @Override
    public void onRemoved(Player player) {
        player.sendMessage("Cover removed!");
        super.onRemoved(player);
    }

    public void buttonClicked(int id, int button, int channel) {
    }
}

