/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.covers;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.io.IFluidIO;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.api.IFluidTransfer;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.interfaces.IAcceptsCovers;
import sunsetsatellite.signalindustries.items.covers.ItemCover;

public class PumpCover
extends CoverBase {
    protected final String texture = "signalindustries:block/pump_cover";

    @Override
    public void openConfiguration(Player player, Direction dir) {
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
    }

    @Override
    public void tick() {
        if (this.machine instanceof IFluidIO && this.machine instanceof IFluidTransfer && this.machine instanceof IFluidInventory && this.machine instanceof TileEntity) {
            TileEntity machineTile = (TileEntity)this.machine;
            IFluidIO fluidIO = (IFluidIO)this.machine;
            IFluidTransfer fluidTransfer = (IFluidTransfer)this.machine;
            IFluidInventory fluidInv = (IFluidInventory)this.machine;
            Connection con = fluidIO.getFluidIOForSide(this.dir);
            int activeSlot = fluidIO.getActiveFluidSlotForSide(this.dir);
            if (activeSlot == -1 || con == Connection.NONE) {
                return;
            }
            TileEntity tile = this.dir.getTileEntity((WorldSource)machineTile.worldObj, machineTile);
            if (tile instanceof IFluidIO && tile instanceof IFluidTransfer && tile instanceof IFluidInventory) {
                IFluidIO otherIO = (IFluidIO)tile;
                IFluidTransfer otherTransfer = (IFluidTransfer)tile;
                IFluidInventory otherFluidInv = (IFluidInventory)tile;
                Connection otherCon = otherIO.getFluidIOForSide(this.dir.getOpposite());
                int otherActiveSlot = otherIO.getActiveFluidSlotForSide(this.dir.getOpposite());
                if (otherCon == Connection.NONE || otherActiveSlot == -1) {
                    return;
                }
                if (con == Connection.INPUT && otherCon == Connection.OUTPUT) {
                    if (otherFluidInv.getFluidInSlot(otherActiveSlot) != null) {
                        fluidTransfer.take(otherFluidInv.getFluidInSlot(otherActiveSlot), this.dir);
                    }
                } else if (con == Connection.OUTPUT && otherCon == Connection.INPUT && fluidInv.getFluidInSlot(activeSlot) != null) {
                    fluidTransfer.give(this.dir);
                }
            }
        }
    }

    @Override
    public String getTexture() {
        return "signalindustries:block/pump_cover";
    }

    @Override
    public ItemCover getItem() {
        return SIItems.pumpCover;
    }

    @Override
    public void onInstalled(Direction dir, IAcceptsCovers machine, Player player) {
        player.sendMessage("Cover installed!");
        super.onInstalled(dir, machine, player);
    }

    @Override
    public void onRemoved(Player player) {
        player.sendMessage("Cover removed!");
        super.onRemoved(player);
    }

    public void buttonClicked(int id, int button, int channel) {
    }
}

