/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.covers;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.covers.RedstoneCover;
import sunsetsatellite.signalindustries.interfaces.IAcceptsCovers;
import sunsetsatellite.signalindustries.items.covers.ItemCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWithName;

public class SwitchCover
extends CoverBase {
    protected final String on = "signalindustries:block/switch_cover_on";
    protected final String off = "signalindustries:block/switch_cover_off";
    public boolean controlledByRedstone = false;

    @Override
    public void openConfiguration(Player player, Direction dir) {
        if (this.machine instanceof Container && this.machine instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.machine;
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/switch_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        } else if (this.machine instanceof TileEntityWithName) {
            TileEntityWithName tile = (TileEntityWithName)((Object)this.machine);
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/switch_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        }
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
        tag.putBoolean("RedstoneControl", this.controlledByRedstone);
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
        this.controlledByRedstone = tag.getBoolean("RedstoneControl");
    }

    @Override
    public void tick() {
        if (this.machine instanceof TileEntityTieredMachineBase && this.controlledByRedstone && this.machine.hasCoverAnywhere(RedstoneCover.class)) {
            RedstoneCover cover = this.machine.getCover(RedstoneCover.class);
            ((TileEntityTieredMachineBase)this.machine).disabled = cover.sensorActive;
        }
    }

    @Override
    public String getTexture() {
        if (this.machine instanceof TileEntityTieredMachineBase) {
            return ((TileEntityTieredMachineBase)this.machine).disabled ? "signalindustries:block/switch_cover_off" : "signalindustries:block/switch_cover_on";
        }
        return "signalindustries:block/switch_cover_on";
    }

    @Override
    public ItemCover getItem() {
        return SIItems.switchCover;
    }

    @Override
    public void onInstalled(Direction dir, IAcceptsCovers machine, Player player) {
        player.sendMessage("Cover installed!");
        super.onInstalled(dir, machine, player);
    }

    @Override
    public void onRemoved(Player player) {
        if (this.machine instanceof TileEntityTieredMachineBase) {
            ((TileEntityTieredMachineBase)this.machine).disabled = false;
        }
        player.sendMessage("Cover removed!");
        super.onRemoved(player);
    }

    public void buttonClicked(int id, int button, int channel) {
        switch (id) {
            case 0: {
                if (!(this.machine instanceof TileEntityTieredMachineBase)) break;
                ((TileEntityTieredMachineBase)this.machine).disabled = !((TileEntityTieredMachineBase)this.machine).disabled;
                break;
            }
            case 1: {
                this.controlledByRedstone = !this.controlledByRedstone;
            }
        }
    }
}

