/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.dim;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.noise.BasePerlinNoise;
import net.minecraft.core.world.noise.CombinedPerlinNoise;
import net.minecraft.core.world.noise.PerlinNoise;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.dim.ChunkDecoratorEternity;
import sunsetsatellite.signalindustries.dim.ChunkGeneratorEternityFarlands;
import sunsetsatellite.signalindustries.dim.SurfaceGeneratorEternity;
import sunsetsatellite.signalindustries.dim.WorldTypeEternity;

public class ChunkGeneratorEternity
extends ChunkGenerator {
    private final CombinedPerlinNoise combinedA;
    private final CombinedPerlinNoise combinedB;
    private final CombinedPerlinNoise combinedC;
    private final CombinedPerlinNoise combinedD;
    private final PerlinNoise octavesA;
    private final PerlinNoise octavesB;
    private final ChunkGeneratorEternityFarlands farlandsGenerator;
    private final SurfaceGenerator sg;

    public ChunkGeneratorEternity(World world) {
        super(world, (ChunkDecorator)new ChunkDecoratorEternity(world));
        this.farlandsGenerator = new ChunkGeneratorEternityFarlands(world);
        long seed = world.getRandomSeed();
        this.combinedA = new CombinedPerlinNoise((BasePerlinNoise)new PerlinNoise(seed, 8, 0), (BasePerlinNoise)new PerlinNoise(seed, 8, 8));
        this.combinedB = new CombinedPerlinNoise((BasePerlinNoise)new PerlinNoise(seed, 8, 16), (BasePerlinNoise)new PerlinNoise(seed, 8, 24));
        this.combinedC = new CombinedPerlinNoise((BasePerlinNoise)new PerlinNoise(seed, 8, 32), (BasePerlinNoise)new PerlinNoise(seed, 8, 40));
        this.combinedD = new CombinedPerlinNoise((BasePerlinNoise)new PerlinNoise(seed, 8, 48), (BasePerlinNoise)new PerlinNoise(seed, 8, 56));
        this.octavesA = new PerlinNoise(seed, 6, 64);
        this.octavesB = new PerlinNoise(seed, 8, 70);
        this.sg = new SurfaceGeneratorEternity(world);
    }

    protected ChunkGeneratorResult doBlockGeneration(Chunk chunk) {
        int val2;
        int x;
        ((WorldTypeEternity)this.world.getWorldType()).fillerBlock = SIBlocks.realityFabric.id();
        ChunkGeneratorResult result = new ChunkGeneratorResult();
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        float mod = 1.3f;
        int[] heightMap = new int[256];
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z = 0; z < 16; ++z) {
                double d;
                double noiseA = this.combinedA.get((double)((float)(chunkX * 16 + x2) * 1.3f), (double)((float)(chunkZ * 16 + z) * 1.3f)) / 6.0 + -4.0;
                double noiseB = this.combinedB.get((double)((float)(chunkX * 16 + x2) * 1.3f), (double)((float)(chunkZ * 16 + z) * 1.3f)) / 5.0 + 10.0 + -4.0;
                if (this.octavesA.get((double)(chunkX * 16 + x2), (double)(chunkZ * 16 + z)) / 8.0 > 0.0) {
                    noiseB = noiseA;
                }
                double height = Math.max(noiseA, noiseB) / 2.0;
                if (d < 0.0) {
                    height *= 0.8;
                }
                heightMap[x2 + z * 16] = (int)height;
            }
        }
        int[] newHeightMap = heightMap;
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int newHeight;
                double val = this.combinedC.get((double)(chunkX * 16 + x << 1), (double)(chunkZ * 16 + z << 1)) / 8.0;
                int n = val2 = this.combinedD.get((double)(chunkX * 16 + x << 1), (double)(chunkZ * 16 + z << 1)) > 0.0 ? 1 : 0;
                if (!(val > 2.0)) continue;
                newHeightMap[x + z * 16] = newHeight = ((newHeightMap[x + z * 16] - val2) / 2 << 1) + val2;
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int val = (int)(this.octavesB.get((double)(chunkX * 16 + x), (double)(chunkZ * 16 + z)) / 24.0) - 4;
                int newHeight = newHeightMap[x + z * 16] + this.world.getWorldType().getOceanY();
                val2 = newHeight + val;
                newHeightMap[x + z * 16] = Math.max(newHeight, val2);
                if (newHeightMap[x + z * 16] > this.world.getWorldType().getMaxY() - 2) {
                    newHeightMap[x + z * 16] = this.world.getWorldType().getMaxY() - 2;
                }
                if (newHeightMap[x + z * 16] < 1) {
                    newHeightMap[x + z * 16] = 1;
                }
                for (int y = this.world.getWorldType().getMinY(); y < this.world.getWorldType().getMaxY(); ++y) {
                    int index = Chunk.makeBlockIndex((int)x, (int)y, (int)z);
                    int blockID = 0;
                    if (y < newHeight) {
                        blockID = this.world.getWorldType().getFillerBlockId();
                    } else if (y < this.world.getWorldType().getOceanY()) {
                        blockID = this.world.getWorldType().getOceanBlockId();
                    }
                    if (y == 0) {
                        blockID = Blocks.BEDROCK.id();
                    }
                    result.setBlock(x, y, z, blockID);
                }
            }
        }
        this.sg.generateSurface(chunk, result);
        return result;
    }
}

