/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.dim;

import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weathers;
import net.minecraft.core.world.wind.WindProvider;
import net.minecraft.core.world.wind.WindProviderGeneric;
import sunsetsatellite.signalindustries.SIBiomes;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.dim.ChunkGeneratorEternity;

public class WorldTypeEternity
extends WorldType {
    public int fillerBlock = SIBlocks.realityFabric.id();

    public WorldTypeEternity(String languageKey) {
        super(WorldType.Properties.of((String)languageKey).defaultWeather(Weathers.OVERWORLD_CLEAR).windManager((WindProvider)new WindProviderGeneric()).brightnessRamp(WorldTypeEternity.getLightRamp()).seasonConfig(SeasonConfig.builder().withSingleSeason(Seasons.NULL).build()).dayNightCycleTicks(24000));
    }

    private static float[] getLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    public int getMinY() {
        return 0;
    }

    public int getMaxY() {
        return 255;
    }

    public int getOceanY() {
        return 32;
    }

    public int getOceanBlockId() {
        return 0;
    }

    public int getFillerBlockId() {
        return this.fillerBlock;
    }

    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(SIBiomes.biomeEternity, 1.0, 1.0, 1.0);
    }

    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorEternity(world);
    }

    public boolean isValidSpawn(World world, int i, int j, int k) {
        return true;
    }

    public float getCelestialAngle(World world, long l, float f) {
        return 0.5f;
    }

    public int getSkyDarken(World world, long l, float f) {
        return 0;
    }

    public boolean mayRespawn() {
        return false;
    }
}

