/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.entities;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public class EntityShockwave
extends Entity {
    public EntityShockwave(@Nullable World world, Vec3i start) {
        super(world);
        this.setSize(10.0f, 10.0f);
        this.setPos(start.x, start.y, start.z);
    }

    protected void defineSynchedData() {
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 40) {
            this.remove();
        }
        if (this.world == null) {
            return;
        }
        List entities = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb);
        for (Entity entity : entities) {
            if (!(entity instanceof Mob)) continue;
            entity.hurt(null, 30, DamageType.BLAST);
            double d = this.x - entity.x;
            double d1 = this.z - entity.z;
            while (d * d + d1 * d1 < 1.0E-4) {
                d = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            ((Mob)entity).attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - entity.yRot;
            ((Mob)entity).knockBack(entity, 30, d, d1);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
    }
}

