/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.invs;

import java.util.ArrayList;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.util.InventorySerializer;

public abstract class InventoryItemFluid
implements Container,
IFluidInventory {
    public ItemStack[] contents = new ItemStack[1];
    public FluidStack[] fluidContents = new FluidStack[1];
    public int[] fluidCapacity = new int[1];
    public ArrayList<ArrayList<Fluid>> acceptedFluids = new ArrayList(this.fluidContents.length);
    public int transferSpeed = 20;
    public final ItemStack container;

    public InventoryItemFluid(ItemStack container) {
        this.container = container;
    }

    public void save() {
        InventorySerializer.saveInvToNBT(this.container, this);
    }

    public void load() {
        InventorySerializer.loadInvFromNBT(this.container, this, this.getContainerSize(), this.getFluidInventorySize());
    }

    @Nullable
    public ItemStack getItem(int index) {
        return this.contents[index];
    }

    @Nullable
    public ItemStack removeItem(int index, int takeAmount) {
        if (this.contents[index] != null) {
            if (this.contents[index].stackSize <= takeAmount) {
                ItemStack itemstack = this.contents[index];
                this.contents[index] = null;
                this.setChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.contents[index].splitStack(takeAmount);
            if (this.contents[index].stackSize <= 0) {
                this.contents[index] = null;
            }
            this.setChanged();
            return itemstack1;
        }
        return null;
    }

    public void setItem(int index, @Nullable ItemStack itemstack) {
        this.contents[index] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getMaxStackSize()) {
            itemstack.stackSize = this.getMaxStackSize();
        }
        this.setChanged();
    }

    public int getContainerSize() {
        return this.contents.length;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player entityplayer) {
        return true;
    }

    public void sortContainer() {
        InventorySorter.sortInventory((ItemStack[])this.contents);
    }

    public boolean canInsertFluid(int slot, FluidStack fluidStack) {
        if (this.getFluidInSlot(slot) != null && !this.getFluidInSlot(slot).isFluidEqual(fluidStack)) {
            return false;
        }
        return Math.min(fluidStack.amount, this.getRemainingCapacity(slot)) > 0;
    }

    public FluidStack getFluidInSlot(int slot) {
        if (this.fluidContents.length == 0) {
            return null;
        }
        if (this.fluidContents[slot] == null || this.fluidContents[slot].fluid == null || this.fluidContents[slot].amount == 0) {
            this.fluidContents[slot] = null;
        }
        return this.fluidContents[slot];
    }

    public int getFluidCapacityForSlot(int slot) {
        return this.fluidCapacity[slot];
    }

    public ArrayList<Fluid> getAllowedFluidsForSlot(int slot) {
        return this.acceptedFluids.get(slot);
    }

    public void setFluidInSlot(int slot, FluidStack fluid) {
        if (fluid == null || fluid.amount == 0 || fluid.fluid == null) {
            this.fluidContents[slot] = null;
            this.onFluidInventoryChanged();
            return;
        }
        if (this.acceptedFluids.get(slot).contains(fluid.fluid) || this.acceptedFluids.get(slot).isEmpty()) {
            this.fluidContents[slot] = fluid;
            this.onFluidInventoryChanged();
        }
    }

    public FluidStack insertFluid(int slot, FluidStack fluidStack) {
        FluidStack stack = this.fluidContents[slot];
        FluidStack split = fluidStack.splitStack(Math.min(fluidStack.amount, this.getRemainingCapacity(slot)));
        if (stack != null && split.amount > 0) {
            this.fluidContents[slot].amount += split.amount;
        } else {
            this.fluidContents[slot] = split;
        }
        return fluidStack;
    }

    public int getRemainingCapacity(int slot) {
        if (this.fluidContents[slot] == null) {
            return this.fluidCapacity[slot];
        }
        return this.fluidCapacity[slot] - this.fluidContents[slot].amount;
    }

    public int getFluidInventorySize() {
        return this.fluidContents.length;
    }

    public void onFluidInventoryChanged() {
    }

    public int getTransferSpeed() {
        return this.transferSpeed;
    }
}

