/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.block.logic.RailDirection;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.signalindustries.SIBlocks;

@Mixin(value={BlockLogicRail.class}, remap=false)
public abstract class BlockLogicRailMixin
extends BlockLogic {
    private BlockLogicRailMixin(Block<?> block, Material material) {
        super(block, material);
    }

    @Shadow
    public abstract RailDirection getRailDirection(WorldSource var1, int var2, int var3, int var4);

    @Shadow
    protected abstract boolean isConnectedPoweredRail1(World var1, int var2, int var3, int var4, boolean var5, int var6);

    @Inject(method={"isConnectedPoweredRail2"}, at={@At(value="HEAD")}, cancellable=true)
    private void isConnectedPoweredRail2(World world, int x, int y, int z, boolean forward, int distance, Axis axis, CallbackInfoReturnable<Boolean> cir) {
        int blockId = world.getBlockId(x, y, z);
        if (blockId == SIBlocks.dilithiumRail.id()) {
            int meta = world.getBlockMetadata(x, y, z);
            boolean isPoweredFlagSet = (meta & 8) != 0;
            RailDirection direction = this.getRailDirection((WorldSource)world, x, y, z);
            if (axis == Axis.X && (direction == RailDirection.STRAIGHT_NS || direction == RailDirection.SLOPE_N || direction == RailDirection.SLOPE_S)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (axis == Axis.Z && (direction == RailDirection.STRAIGHT_EW || direction == RailDirection.SLOPE_E || direction == RailDirection.SLOPE_W)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (isPoweredFlagSet) {
                if (world.hasNeighborSignal(x, y, z) || world.hasNeighborSignal(x, y + 1, z)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                cir.setReturnValue((Object)this.isConnectedPoweredRail1(world, x, y, z, forward, distance + 1));
                return;
            }
        }
    }

    @Inject(method={"onNeighborBlockChange"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/block/Blocks;getBlock(I)Lnet/minecraft/core/block/Block;", shift=At.Shift.AFTER)}, cancellable=true)
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId, CallbackInfo ci) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean isPoweredFlagSet = (meta & 8) != 0;
        RailDirection railDirection = this.getRailDirection((WorldSource)world, x, y, z);
        if (this.block == SIBlocks.dilithiumRail) {
            boolean gettingPower = world.hasNeighborSignal(x, y, z) || world.hasNeighborSignal(x, y + 1, z) || this.isConnectedPoweredRail1(world, x, y, z, true, 0) || this.isConnectedPoweredRail1(world, x, y, z, false, 0);
            boolean changedMeta = false;
            if (gettingPower && !isPoweredFlagSet) {
                world.setBlockMetadataWithNotify(x, y, z, railDirection.meta | 8);
                changedMeta = true;
            } else if (!gettingPower && isPoweredFlagSet) {
                world.setBlockMetadataWithNotify(x, y, z, railDirection.meta);
                changedMeta = true;
            }
            if (changedMeta) {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id());
                if (railDirection.isSloped()) {
                    world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id());
                }
            }
            ci.cancel();
        }
    }
}

