/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.overworld.ChunkDecoratorOverworld;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIConfig;
import sunsetsatellite.signalindustries.worldgen.WorldFeatureGeode;
import sunsetsatellite.signalindustries.worldgen.WorldFeatureMeteor;
import sunsetsatellite.signalindustries.worldgen.WorldFeatureObelisk;

@Debug(export=true)
@Mixin(value={ChunkDecoratorOverworld.class}, remap=false)
public class ChunkDecoratorOverworldMixin {
    @Shadow
    @Final
    private World world;

    @Inject(method={"decorate"}, at={@At(value="TAIL")})
    public void decorate(Chunk chunk, CallbackInfo ci) {
        int j;
        int k;
        int i;
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        float oreHeightModifier = (float)rangeY / 128.0f;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = this.world.getHeightValue(x + 16, z + 16);
        Random rand = new Random(this.world.getRandomSeed());
        long l1 = rand.nextLong() / 2L * 2L + 1L;
        long l2 = rand.nextLong() / 2L * 2L + 1L;
        rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.world.getRandomSeed());
        if (rand.nextInt(SIConfig.config.getInt("WorldGen.signaliteGeodeChance")) == 0) {
            i = x + rand.nextInt(16);
            int j2 = minY + 12 + rand.nextInt(rangeY / 8);
            int k2 = z + rand.nextInt(16);
            new WorldFeatureGeode(SIBlocks.signalumOre.id(), 0, 20, 4).place(this.world, rand, i, j2, k2);
        }
        if (rand.nextInt(SIConfig.config.getInt("WorldGen.ironMeteorChance")) == 0) {
            i = x + rand.nextInt(16);
            k = z + rand.nextInt(16);
            j = this.world.getHeightValue(i, k);
            new WorldFeatureMeteor(Blocks.ORE_IRON_BASALT.id(), 0, 25).place(this.world, rand, i, j, k);
        }
        if (rand.nextInt(SIConfig.config.getInt("WorldGen.signaliteMeteorChance")) == 0) {
            i = x + rand.nextInt(16);
            k = z + rand.nextInt(16);
            j = this.world.getHeightValue(i, k);
            new WorldFeatureMeteor(SIBlocks.signalumOre.id(), 0, 15).place(this.world, rand, i, j, k);
        }
        if (rand.nextInt(SIConfig.config.getInt("WorldGen.dilithiumMeteorChance")) == 0) {
            i = x + rand.nextInt(16);
            k = z + rand.nextInt(16);
            j = this.world.getHeightValue(i, k);
            new WorldFeatureMeteor(SIBlocks.dilithiumOre.id(), 0, 5).place(this.world, rand, i, j, k);
        }
        if (rand.nextInt(SIConfig.config.getInt("WorldGen.obeliskChance")) == 0) {
            i = x + rand.nextInt(16);
            k = z + rand.nextInt(16);
            j = this.world.getHeightValue(i, k);
            new WorldFeatureObelisk().place(this.world, rand, i, j, k);
        }
    }
}

