/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustriesClient;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.interfaces.mixins.IWarpPlayer;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuitClient;
import sunsetsatellite.signalindustries.render.ShadersRendererSI;

@Mixin(value={PlayerLocal.class}, remap=false)
public abstract class PlayerLocalMixin
extends Player
implements IWarpPlayer,
IPlayerPowerSuit<SignalumPowerSuitClient> {
    @Shadow
    protected Minecraft mc;
    @Unique
    public SignalumPowerSuitClient powerSuit = null;
    @Unique
    public CompoundTag powerSuitData = null;
    @Unique
    public boolean nightVisionShader = false;

    private PlayerLocalMixin(World world) {
        super(world);
    }

    @Override
    public void warp(int dim) {
        SignalIndustriesClient.movePlayerToDimension((Player)((PlayerLocal)this), dim);
    }

    @Override
    public SignalumPowerSuitClient getPowerSuit() {
        return this.powerSuit;
    }

    @Override
    public CompoundTag getPowerSuitData() {
        return this.powerSuitData;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void saveSuitData(CompoundTag tag, CallbackInfo ci) {
        if (this.powerSuit != null) {
            this.powerSuit.saveData(tag);
        }
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    public void powerSuitUpdate(CallbackInfo ci) {
        ItemStack[] armorInventory;
        for (ItemStack itemStack : armorInventory = this.inventory.armorInventory) {
            if (itemStack == null) {
                this.powerSuit = null;
                this.toggleNightVision(false, null);
                return;
            }
            if (itemStack.getItem() instanceof ItemSignalumPowerSuit) continue;
            this.toggleNightVision(false, null);
            this.powerSuit = null;
            return;
        }
        if (this.powerSuit == null) {
            this.powerSuit = new SignalumPowerSuitClient((PlayerLocal)this);
        } else {
            this.powerSuit.tick();
        }
        SignalumPowerSuitClient ps = this.getPowerSuit();
        if (ps != null && ps.active && ps.hasAttachment(SIItems.nightVisionLens)) {
            if (ps.getAttachment(SIItems.nightVisionLens).getData().getBoolean("active") && !this.nightVisionShader && ps.getEnergy() > 1) {
                this.toggleNightVision(true, ps);
            } else if ((!ps.getAttachment(SIItems.nightVisionLens).getData().getBoolean("active") || ps.getEnergy() < 1) && this.nightVisionShader) {
                this.toggleNightVision(false, ps);
            }
        }
    }

    @Unique
    private void toggleNightVision(boolean nightVision, SignalumPowerSuit ps) {
        if (nightVision && !this.nightVisionShader) {
            this.nightVisionShader = true;
            if (Shaders.enableShaders) {
                this.mc.setRenderer((Renderer)new ShadersRendererSI(this.mc, "nightvision/", ps));
                this.mc.renderer.reload();
                this.mc.fullbright = true;
                this.mc.renderGlobal.loadRenderers();
            }
        } else if (!nightVision && this.nightVisionShader) {
            this.nightVisionShader = false;
            if (Shaders.enableShaders) {
                this.mc.setRenderer((Renderer)new ShadersRenderer(this.mc));
                this.mc.renderer.reload();
                this.mc.fullbright = false;
                this.mc.renderGlobal.loadRenderers();
            }
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.containsKey("PowerSuit")) {
            this.powerSuitData = tag.getCompound("PowerSuit");
        }
    }

    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (this.powerSuit != null && this.powerSuit.active && this.powerSuit.status != SignalumPowerSuit.Status.OVERHEAT) {
            if (this.powerSuit.getEnergy() >= newDamage) {
                if (damageType != null && damageType.shouldDamageArmor()) {
                    int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
                    this.inventory.damageArmor(armorDamage);
                }
                this.powerSuit.decrementEnergy(newDamage);
                return;
            }
            if (damageType == DamageType.FIRE) {
                this.powerSuit.temperature += 0.5f;
            }
        }
        if (this.inventory.armorItemInSlot(2) != null && this.inventory.armorItemInSlot(2).getData().getBoolean("active_shield") && damageType == DamageType.COMBAT) {
            return;
        }
        super.damageEntity(damage, damageType);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    public void updateSpeed(CallbackInfo ci) {
        if (this.powerSuit != null && this.powerSuit.active && this.powerSuit.hasAttachment(SIItems.movementBoosters, Catalyst.listOf((Object[])new SignalumPowerSuit.AttachmentLocation[]{SignalumPowerSuit.AttachmentLocation.BOOT_BACK_R, SignalumPowerSuit.AttachmentLocation.BOOT_BACK_L})) && this.powerSuit.getAttachment(SIItems.movementBoosters) != null && this.powerSuit.getAttachment(SIItems.movementBoosters).getData().getBoolean("active")) {
            this.speed += (float)((double)this.baseSpeed * 1.5);
        }
    }
}

