/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.interfaces.mixins.IWarpPlayer;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;

@Mixin(value={PlayerServer.class}, remap=false)
public abstract class PlayerServerMixin
extends Player
implements IWarpPlayer,
IPlayerPowerSuit<SignalumPowerSuit> {
    @Shadow
    public MinecraftServer mcServer;
    @Unique
    public SignalumPowerSuit powerSuit = null;
    @Unique
    public CompoundTag powerSuitData = null;

    private PlayerServerMixin(World world) {
        super(world);
    }

    @Override
    public void warp(int dim) {
        this.mcServer.playerList.sendPlayerToOtherDimension((PlayerServer)this, dim, null, false);
    }

    @Override
    public SignalumPowerSuit getPowerSuit() {
        return this.powerSuit;
    }

    @Override
    public CompoundTag getPowerSuitData() {
        return this.powerSuitData;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void saveSuitData(CompoundTag tag, CallbackInfo ci) {
        if (this.powerSuit != null) {
            this.powerSuit.saveData(tag);
        }
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    public void powerSuitUpdate(CallbackInfo ci) {
        ItemStack[] armorInventory;
        for (ItemStack itemStack : armorInventory = this.inventory.armorInventory) {
            if (itemStack == null) {
                this.powerSuit = null;
                return;
            }
            if (itemStack.getItem() instanceof ItemSignalumPowerSuit) continue;
            this.powerSuit = null;
            return;
        }
        if (this.powerSuit == null) {
            this.powerSuit = new SignalumPowerSuit(this);
        } else {
            this.powerSuit.tick();
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.containsKey("PowerSuit")) {
            this.powerSuitData = tag.getCompound("PowerSuit");
        }
    }

    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (this.powerSuit != null && this.powerSuit.active && this.powerSuit.status != SignalumPowerSuit.Status.OVERHEAT) {
            if (this.powerSuit.getEnergy() >= newDamage) {
                if (damageType != null && damageType.shouldDamageArmor()) {
                    int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
                    this.inventory.damageArmor(armorDamage);
                }
                this.powerSuit.decrementEnergy(newDamage);
                return;
            }
            if (damageType == DamageType.FIRE) {
                this.powerSuit.temperature += 0.5f;
            }
        }
        if (this.inventory.armorItemInSlot(2) != null && this.inventory.armorItemInSlot(2).getData().getBoolean("active_shield") && damageType == DamageType.COMBAT) {
            return;
        }
        super.damageEntity(damage, damageType);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    public void updateSpeed(CallbackInfo ci) {
        if (this.powerSuit != null && this.powerSuit.active && this.powerSuit.hasAttachment(SIItems.movementBoosters, Catalyst.listOf((Object[])new SignalumPowerSuit.AttachmentLocation[]{SignalumPowerSuit.AttachmentLocation.BOOT_BACK_R, SignalumPowerSuit.AttachmentLocation.BOOT_BACK_L})) && this.powerSuit.getAttachment(SIItems.movementBoosters) != null && this.powerSuit.getAttachment(SIItems.movementBoosters).getData().getBoolean("active")) {
            this.speed += (float)((double)this.baseSpeed * 1.5);
        }
    }
}

