/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.items.ItemBlueprint;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBuilder;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageBuilderConfig
implements NetworkMessage {
    public Vec3i pos;
    public Direction dir;
    public boolean toggle;
    public Class<? extends TileEntity> tileClass;

    public NetworkMessageBuilderConfig(Vec3i pos, Direction dir, boolean toggle, Class<? extends TileEntity> tileClass) {
        this.pos = pos;
        this.dir = dir;
        this.toggle = toggle;
        this.tileClass = tileClass;
    }

    public NetworkMessageBuilderConfig() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.dir.ordinal());
        packet.writeBoolean(this.toggle);
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.dir = Direction.values()[packet.readInt()];
        this.toggle = packet.readBoolean();
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof TileEntityBuilder && tileEntity.worldObj != null) {
            TileEntityBuilder builder = (TileEntityBuilder)tileEntity;
            if (!this.pos.equals((Object)builder.offset) || !this.dir.equals((Object)builder.rotation)) {
                builder.offset = this.pos;
                builder.rotation = this.dir;
                builder.reset();
            }
            if (this.toggle && builder.workTimer.isPaused()) {
                if (builder.fluidContents[0] != null && builder.itemContents[0] != null && builder.itemContents[0].getItem() instanceof ItemBlueprint) {
                    builder.workTimer.unpause();
                    builder.setStructureToBuild();
                }
                for (BlockInstance block : new ArrayList<BlockInstance>(builder.buildingBlocks)) {
                    if (!block.exists(builder.worldObj)) continue;
                    builder.buildingBlocks.remove(block);
                    ++builder.builtBlocks;
                }
                if (builder.buildingBlockIndex >= builder.buildingBlocks.size()) {
                    builder.buildingBlockIndex = 0;
                }
            } else {
                builder.workTimer.pause();
            }
        }
    }
}

