/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.core.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessagePowerSuitRemoteSync
implements NetworkMessage {
    public CompoundTag data;
    public UUID uuid;
    public String username;

    public NetworkMessagePowerSuitRemoteSync() {
    }

    public NetworkMessagePowerSuitRemoteSync(String username, UUID uuid, CompoundTag data) {
        this.data = data;
        this.uuid = uuid;
        this.username = username;
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeString(this.username);
        packet.writeString(this.uuid.toString());
        packet.writeCompoundTag(this.data);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.username = packet.readString();
        this.uuid = UUID.fromString(packet.readString());
        this.data = packet.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (context.player.world != null) {
            for (Player player : context.player.world.players) {
                Object suit;
                if (!(player instanceof PlayerRemote) || (player.uuid != null || !player.username.equals(this.username)) && !Objects.equals(player.uuid, this.uuid) || !(player instanceof IPlayerPowerSuit) || (suit = ((IPlayerPowerSuit)player).getPowerSuit()) == null) continue;
                suit.loadData(this.data.getCompound("PowerSuit"));
            }
        }
    }
}

