/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineSimple;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageRecipeIdChange
implements NetworkMessage {
    public Vec3i pos;
    public int recipeId;
    public Class<? extends TileEntity> tileClass;

    public NetworkMessageRecipeIdChange(int recipeId, Vec3i pos, Class<? extends TileEntity> tileClass) {
        this.recipeId = recipeId;
        this.pos = pos;
        this.tileClass = tileClass;
    }

    public NetworkMessageRecipeIdChange() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.recipeId);
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.recipeId = packet.readInt();
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && this.tileClass == (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)).getClass() && tileEntity instanceof TileEntityTieredMachineSimple) {
            ((TileEntityTieredMachineSimple)tileEntity).recipeId = this.recipeId;
        }
    }
}

