/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.util.PipeType;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageSensorPipeSetFilter
implements NetworkMessage {
    public Vec3i pos;
    public Class<? extends TileEntity> tileClass;
    public ItemStack stack;

    public NetworkMessageSensorPipeSetFilter(Vec3i pos, ItemStack stack, Class<? extends TileEntity> tileClass) {
        this.pos = pos;
        this.stack = stack;
        this.tileClass = tileClass;
    }

    public NetworkMessageSensorPipeSetFilter() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
        if (this.stack == null) {
            packet.writeInt(-1);
        } else {
            packet.writeInt(1);
            nbt = new CompoundTag();
            this.stack.writeToNBT(nbt);
            packet.writeCompoundTag(nbt);
        }
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
        this.stack = packet.readInt() == -1 ? null : ItemStack.readItemStackFromNbt((CompoundTag)packet.readCompoundTag());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof TileEntityItemConduit && tileEntity.worldObj != null) {
            TileEntityItemConduit itemConduit = (TileEntityItemConduit)tileEntity;
            if (itemConduit.type == PipeType.SENSOR) {
                itemConduit.sensorStack = this.stack;
            }
        }
    }
}

