/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.powersuit;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.abilities.powersuit.SuitBaseAbility;
import sunsetsatellite.signalindustries.abilities.powersuit.SuitBaseEffectAbility;
import sunsetsatellite.signalindustries.interfaces.IApplicationItem;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.interfaces.IPowerSuit;
import sunsetsatellite.signalindustries.invs.InventoryAbilityModule;
import sunsetsatellite.signalindustries.invs.InventoryItemFluid;
import sunsetsatellite.signalindustries.items.applications.base.ItemWithAbility;
import sunsetsatellite.signalindustries.items.applications.base.ItemWithUtility;
import sunsetsatellite.signalindustries.items.attachments.ItemAttachment;
import sunsetsatellite.signalindustries.mp.message.NetworkMessagePowerSuitRemoteSync;
import sunsetsatellite.signalindustries.mp.message.NetworkMessagePowerSuitSync;
import sunsetsatellite.signalindustries.powersuit.InventoryPowerSuit;
import sunsetsatellite.signalindustries.util.ApplicationType;
import sunsetsatellite.signalindustries.util.AttachmentPoint;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class SignalumPowerSuit
implements IPowerSuit {
    public final Player player;
    public boolean active = false;
    private boolean cooling = false;
    public float temperature = 20.0f;
    public Status status = Status.OK;
    public InventoryPowerSuit helmet;
    public InventoryPowerSuit chestplate;
    public InventoryPowerSuit leggings;
    public InventoryPowerSuit boots;
    public InventoryAbilityModule module;
    public int selectedApplicationSlot = 0;
    public HashMap<SuitBaseAbility, Integer> cooldowns = new HashMap();
    public HashMap<SuitBaseEffectAbility, Integer> effectTimes = new HashMap();
    protected static final int PIECE_HEAD = 3;
    protected static final int PIECE_CHEST = 2;
    protected static final int PIECE_LEGS = 1;
    protected static final int PIECE_BOOTS = 0;

    public SignalumPowerSuit(Player player) {
        this.player = player;
        this.helmet = new InventoryPowerSuit(player.inventory.armorItemInSlot(3));
        this.chestplate = new InventoryPowerSuit(player.inventory.armorItemInSlot(2));
        this.leggings = new InventoryPowerSuit(player.inventory.armorItemInSlot(1));
        this.boots = new InventoryPowerSuit(player.inventory.armorItemInSlot(0));
        if (((IPlayerPowerSuit)player).getPowerSuitData() != null) {
            this.loadData(((IPlayerPowerSuit)player).getPowerSuitData());
        }
    }

    @Override
    public int getEnergy() {
        if (this.chestplate.fluidContents[0] == null) {
            return 0;
        }
        return this.chestplate.fluidContents[0].amount;
    }

    @Override
    public int getMaxEnergy() {
        return this.chestplate.fluidCapacity[0];
    }

    @Override
    public float getEnergyPercent() {
        return (float)this.getEnergy() / (float)this.getMaxEnergy() * 100.0f;
    }

    @Override
    public void decrementEnergy(int amount) {
        if (this.chestplate.fluidContents[0] == null) {
            return;
        }
        this.chestplate.fluidContents[0].amount -= amount;
        this.chestplate.onFluidInventoryChanged();
        InventorySerializer.saveInvToNBT(this.chestplate.container, this.chestplate);
    }

    @Override
    public void tick() {
        int i;
        this.verify();
        if (this.player.world != null && this.player.world.isClientSide) {
            return;
        }
        if (EnvironmentHelper.isServerEnvironment()) {
            ItemStack[] data = new CompoundTag();
            this.saveData((CompoundTag)data);
            NetworkHandler.sendToPlayer((Player)this.player, (NetworkMessage)new NetworkMessagePowerSuitSync((CompoundTag)data));
            NetworkHandler.sendToAllPlayers((NetworkMessage)new NetworkMessagePowerSuitRemoteSync(this.player.username, this.player.uuid, (CompoundTag)data));
        }
        this.status = this.getEnergyPercent() == 0.0f ? Status.NO_ENERGY : (this.getEnergyPercent() < 15.0f ? Status.LOW_ENERGY : Status.OK);
        if (this.temperature > 100.0f) {
            this.status = Status.OVERHEAT;
            for (ItemStack itemStack : this.player.inventory.armorInventory) {
                itemStack.damageItem(1, (Entity)this.player);
            }
        }
        if (this.temperature > 75.0f && !this.cooling) {
            this.cooling = true;
        }
        if (this.temperature <= 20.0f && this.cooling) {
            this.cooling = false;
        }
        if (this.player.isInLava()) {
            this.temperature += 0.25f;
        }
        if (this.cooling) {
            ItemStack wings;
            float value = 0.05f;
            if (this.player.isInWaterOrRain()) {
                value += 0.2f;
            }
            if (this.hasAttachment(SIItems.crystalWings) && (wings = this.getAttachment(SIItems.crystalWings)) != null && wings.getData().getBoolean("active")) {
                value += 0.8f;
            }
            this.temperature -= value;
            this.decrementEnergy(1);
        }
        if (this.temperature > 20.0f) {
            ItemStack wings;
            this.temperature -= 0.01f;
            if (this.hasAttachment(SIItems.crystalWings) && (wings = this.getAttachment(SIItems.crystalWings)) != null && wings.getData().getBoolean("active")) {
                this.temperature -= 0.49f;
            }
        }
        this.chestplate.fluidCapacity[0] = this.hasAttachment(SIItems.extendedEnergyPack) ? 64000 : 32000;
        ItemStack[] contents = this.helmet.contents;
        int contentsLength = contents.length;
        for (i = 0; i < contentsLength; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null) continue;
            ((ItemAttachment)itemStack.getItem()).tick(itemStack, this, this.player, this.player.world, i);
        }
        contents = this.chestplate.contents;
        contentsLength = contents.length;
        for (i = 0; i < contentsLength; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null) continue;
            ((ItemAttachment)itemStack.getItem()).tick(itemStack, this, this.player, this.player.world, i);
        }
        contents = this.leggings.contents;
        contentsLength = contents.length;
        for (i = 0; i < contentsLength; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null) continue;
            ((ItemAttachment)itemStack.getItem()).tick(itemStack, this, this.player, this.player.world, i);
        }
        contents = this.boots.contents;
        contentsLength = contents.length;
        for (i = 0; i < contentsLength; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null) continue;
            ((ItemAttachment)itemStack.getItem()).tick(itemStack, this, this.player, this.player.world, i);
        }
        ArrayList<SuitBaseAbility> temp = new ArrayList<SuitBaseAbility>();
        for (Map.Entry<SuitBaseAbility, Integer> entry : this.cooldowns.entrySet()) {
            entry.setValue(entry.getValue() - 1);
            if (entry.getValue() > 0) continue;
            temp.add(entry.getKey());
        }
        for (Map.Entry<SuitBaseAbility, Integer> entry : this.effectTimes.entrySet()) {
            entry.setValue(entry.getValue() - 1);
            switch (((SuitBaseEffectAbility)entry.getKey()).activationType) {
                case POSITION: {
                    ((SuitBaseEffectAbility)entry.getKey()).tick(this.player, this.player.world, this);
                }
                case SELF: {
                    ((SuitBaseEffectAbility)entry.getKey()).tick(this.player, this.player.world, this);
                    break;
                }
                case TARGET: {
                    ((SuitBaseEffectAbility)entry.getKey()).tick(this.player, this.player.world, this);
                }
            }
            if (entry.getValue() > 0) continue;
            switch (((SuitBaseEffectAbility)entry.getKey()).activationType) {
                case POSITION: {
                    ((SuitBaseEffectAbility)entry.getKey()).deactivate(this.player, this.player.world, this);
                    break;
                }
                case SELF: {
                    ((SuitBaseEffectAbility)entry.getKey()).deactivate(this.player, this.player.world, this);
                    break;
                }
                case TARGET: {
                    ((SuitBaseEffectAbility)entry.getKey()).deactivate(this.player, this.player.world, this);
                }
            }
            this.cooldowns.put(entry.getKey(), ((SuitBaseEffectAbility)entry.getKey()).cooldown);
            this.effectTimes.remove(entry.getKey());
        }
        for (SuitBaseAbility suitBaseAbility : temp) {
            this.cooldowns.remove(suitBaseAbility);
        }
        for (Iterator<Map.Entry<SuitBaseAbility, Integer>> iterator : this.player.inventory.armorInventory) {
            if (!iterator.isItemDamaged() || this.getEnergy() <= 0 || this.status == Status.OVERHEAT) continue;
            this.decrementEnergy(1);
            iterator.repairItem(1);
        }
    }

    public void verify() {
        if (this.helmet.container != this.player.inventory.armorItemInSlot(3)) {
            this.helmet = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(3));
        }
        if (this.chestplate.container != this.player.inventory.armorItemInSlot(2)) {
            this.chestplate = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(2));
        }
        if (this.leggings.container != this.player.inventory.armorItemInSlot(1)) {
            this.leggings = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(1));
        }
        if (this.boots.container != this.player.inventory.armorItemInSlot(0)) {
            this.boots = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(0));
        }
        this.module = this.getModule() != null ? new InventoryAbilityModule(this.getModule()) : null;
    }

    public void reload() {
        if (this.player.inventory.armorItemInSlot(3) != null && this.player.inventory.armorItemInSlot(2) != null && this.player.inventory.armorItemInSlot(1) != null && this.player.inventory.armorItemInSlot(0) != null) {
            this.helmet = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(3));
            this.chestplate = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(2));
            this.leggings = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(1));
            this.boots = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(0));
        }
    }

    public ItemStack getModule() {
        return this.chestplate.contents[0];
    }

    @Override
    public InventoryPowerSuit getArmorPiece(int i) {
        switch (i) {
            case 3: {
                return this.helmet;
            }
            case 2: {
                return this.chestplate;
            }
            case 1: {
                return this.leggings;
            }
            case 0: {
                return this.boots;
            }
        }
        return null;
    }

    @Override
    public boolean hasAttachment(ItemAttachment attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !content.getItem().equals(attachment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAttachmentClass(Class<? extends ItemAttachment> attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !attachment.isInstance(content.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAttachment(ItemAttachment attachment, List<AttachmentLocation> locations) {
        for (AttachmentLocation location : locations) {
            InventoryPowerSuit armorPieceInv = this.getArmorPiece(location.armorPiece);
            ItemStack armorPieceAttachment = armorPieceInv.getItem(location.slot);
            if (armorPieceAttachment == null || !armorPieceAttachment.getItem().equals(attachment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getAttachment(ItemAttachment attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !content.getItem().equals(attachment)) continue;
                return content;
            }
        }
        return null;
    }

    @Override
    public ItemStack getAttachmentClass(Class<? extends ItemAttachment> attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !attachment.isInstance(content.getItem())) continue;
                return content;
            }
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void activateApplication() {
        if (this.module != null && this.module.contents[this.selectedApplicationSlot] != null) {
            IApplicationItem app = (IApplicationItem)this.module.contents[this.selectedApplicationSlot].getItem();
            if (app.getType() == ApplicationType.ABILITY) {
                SuitBaseAbility selectedAbility = ((ItemWithAbility)this.module.contents[this.selectedApplicationSlot].getItem()).getApplication();
                if (selectedAbility instanceof SuitBaseEffectAbility) {
                    if (!this.cooldowns.containsKey(selectedAbility) && !this.effectTimes.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                        this.decrementEnergy(selectedAbility.cost);
                        selectedAbility.activate(this.player, this.player.world, this);
                        selectedAbility.activationType = SuitBaseAbility.ActivationType.SELF;
                        this.effectTimes.put((SuitBaseEffectAbility)selectedAbility, ((SuitBaseEffectAbility)selectedAbility).effectTime);
                    }
                } else if (!this.cooldowns.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                    this.cooldowns.put(selectedAbility, selectedAbility.cooldown);
                    this.decrementEnergy(selectedAbility.cost);
                    selectedAbility.activate(this.player, this.player.world, this);
                    selectedAbility.activationType = SuitBaseAbility.ActivationType.SELF;
                }
            } else if (app.getType() == ApplicationType.UTILITY) {
                ItemWithUtility item = (ItemWithUtility)this.module.contents[this.selectedApplicationSlot].getItem();
                item.activate(this.module.contents[this.selectedApplicationSlot], this, this.player, this.player.world);
            }
        }
    }

    public void activateApplication(Entity entity) {
        if (this.module != null && this.module.contents[this.selectedApplicationSlot] != null) {
            IApplicationItem app = (IApplicationItem)this.module.contents[this.selectedApplicationSlot].getItem();
            if (app.getType() == ApplicationType.ABILITY) {
                SuitBaseAbility selectedAbility = ((ItemWithAbility)this.module.contents[this.selectedApplicationSlot].getItem()).getApplication();
                if (selectedAbility instanceof SuitBaseEffectAbility) {
                    if (!this.cooldowns.containsKey(selectedAbility) && !this.effectTimes.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                        this.decrementEnergy(selectedAbility.cost);
                        selectedAbility.activate(this.player, entity, this.player.world, this);
                        selectedAbility.activationType = SuitBaseAbility.ActivationType.TARGET;
                        this.effectTimes.put((SuitBaseEffectAbility)selectedAbility, ((SuitBaseEffectAbility)selectedAbility).effectTime);
                    }
                } else if (!this.cooldowns.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                    this.cooldowns.put(selectedAbility, selectedAbility.cooldown);
                    this.decrementEnergy(selectedAbility.cost);
                    selectedAbility.activate(this.player, entity, this.player.world, this);
                    selectedAbility.activationType = SuitBaseAbility.ActivationType.TARGET;
                }
            } else if (app.getType() == ApplicationType.UTILITY) {
                ItemWithUtility item = (ItemWithUtility)this.module.contents[this.selectedApplicationSlot].getItem();
                item.activate(this.module.contents[this.selectedApplicationSlot], this, this.player, this.player.world);
            }
        }
    }

    public void activateApplication(int x, int y, int z) {
        if (this.module != null && this.module.contents[this.selectedApplicationSlot] != null) {
            IApplicationItem app = (IApplicationItem)this.module.contents[this.selectedApplicationSlot].getItem();
            if (app.getType() == ApplicationType.ABILITY) {
                SuitBaseAbility selectedAbility = ((ItemWithAbility)this.module.contents[this.selectedApplicationSlot].getItem()).getApplication();
                if (selectedAbility instanceof SuitBaseEffectAbility) {
                    if (!this.cooldowns.containsKey(selectedAbility) && !this.effectTimes.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                        this.decrementEnergy(selectedAbility.cost);
                        selectedAbility.activate(x, y, z, this.player, this.player.world, this);
                        selectedAbility.activationType = SuitBaseAbility.ActivationType.POSITION;
                        this.effectTimes.put((SuitBaseEffectAbility)selectedAbility, ((SuitBaseEffectAbility)selectedAbility).effectTime);
                    }
                } else if (!this.cooldowns.containsKey(selectedAbility) && this.getEnergy() >= selectedAbility.cost) {
                    this.cooldowns.put(selectedAbility, selectedAbility.cooldown);
                    this.decrementEnergy(selectedAbility.cost);
                    selectedAbility.activate(x, y, z, this.player, this.player.world, this);
                    selectedAbility.activationType = SuitBaseAbility.ActivationType.POSITION;
                }
            } else if (app.getType() == ApplicationType.UTILITY) {
                ItemWithUtility item = (ItemWithUtility)this.module.contents[this.selectedApplicationSlot].getItem();
                item.activate(this.module.contents[this.selectedApplicationSlot], this, this.player, this.player.world);
            }
        }
    }

    public void activateAttachment(String attachmentKeybind, boolean shift, boolean alt, boolean ctrl) {
        ItemStack stack;
        int slot = -1;
        InventoryItemFluid inv = null;
        for (AttachmentLocation attachment : AttachmentLocation.values()) {
            if (!attachmentKeybind.contains(attachment.id)) continue;
            slot = attachment.slot;
            inv = this.getArmorPiece(attachment.armorPiece);
            break;
        }
        if (slot != -1 && inv != null && (stack = inv.getItem(slot)) != null) {
            ItemAttachment attachment = (ItemAttachment)stack.getItem();
            if (alt) {
                attachment.altActivate(stack, this, this.player, this.player.world, shift, alt, ctrl);
            } else {
                attachment.activate(stack, this, this.player, this.player.world, shift, alt, ctrl);
            }
        }
    }

    @Override
    public void saveData(CompoundTag tag) {
        CompoundTag suitTag = new CompoundTag();
        suitTag.putFloat("Temperature", this.temperature);
        suitTag.putBoolean("Active", this.active);
        suitTag.putInt("Status", this.status.ordinal());
        suitTag.putInt("SelectedApplicationSlot", this.selectedApplicationSlot);
        InventorySerializer.saveInvToNBT(this.helmet.container, this.helmet);
        InventorySerializer.saveInvToNBT(this.chestplate.container, this.chestplate);
        InventorySerializer.saveInvToNBT(this.leggings.container, this.leggings);
        InventorySerializer.saveInvToNBT(this.boots.container, this.boots);
        CompoundTag helmetTag = new CompoundTag();
        CompoundTag chestplateTag = new CompoundTag();
        CompoundTag leggingsTag = new CompoundTag();
        CompoundTag bootsTag = new CompoundTag();
        this.helmet.container.writeToNBT(helmetTag);
        this.chestplate.container.writeToNBT(chestplateTag);
        this.leggings.container.writeToNBT(leggingsTag);
        this.boots.container.writeToNBT(bootsTag);
        suitTag.put("Helmet", (Tag)helmetTag);
        suitTag.put("Chestplate", (Tag)chestplateTag);
        suitTag.put("Leggings", (Tag)leggingsTag);
        suitTag.put("Boots", (Tag)bootsTag);
        tag.putCompound("PowerSuit", suitTag);
    }

    @Override
    public void loadData(CompoundTag suitTag) {
        this.active = suitTag.getBoolean("Active");
        this.temperature = suitTag.getFloat("Temperature");
        this.status = Status.values()[suitTag.getInteger("Status")];
        this.selectedApplicationSlot = suitTag.getInteger("SelectedApplicationSlot");
        if (suitTag.containsKey("Helmet") && suitTag.containsKey("Chestplate") && suitTag.containsKey("Leggings") && suitTag.containsKey("Boots")) {
            CompoundTag helmetTag = suitTag.getCompound("Helmet");
            CompoundTag chestplateTag = suitTag.getCompound("Chestplate");
            CompoundTag leggingsTag = suitTag.getCompound("Leggings");
            CompoundTag bootsTag = suitTag.getCompound("Boots");
            this.helmet.container.readFromNBT(helmetTag);
            this.chestplate.container.readFromNBT(chestplateTag);
            this.leggings.container.readFromNBT(leggingsTag);
            this.boots.container.readFromNBT(bootsTag);
            this.reload();
        }
    }

    public static enum Status {
        OK(TextFormatting.LIME),
        LOW_ENERGY(TextFormatting.ORANGE),
        NO_ENERGY(TextFormatting.RED),
        OVERHEAT(TextFormatting.RED),
        CRITICAL_DAMAGE(TextFormatting.RED);

        private final TextFormatting color;

        private Status(TextFormatting color) {
            this.color = color;
        }

        public String toString() {
            return this.color + super.toString().replace("_", " ") + TextFormatting.WHITE;
        }
    }

    public static enum AttachmentLocation {
        HEAD_TOP("headTop", 0, 3, AttachmentPoint.HEAD_TOP),
        HEAD_LENS("headLens", 1, 3, AttachmentPoint.HEAD_LENS),
        COLORIZER("colorizer", 8, 2, AttachmentPoint.COLORIZER),
        CORE_BACK("coreBack", 1, 2, AttachmentPoint.CORE_BACK),
        ARM_FRONT_L("armFrontL", 2, 2, AttachmentPoint.ARM_FRONT),
        ARM_FRONT_R("armFrontR", 7, 2, AttachmentPoint.ARM_FRONT),
        ARM_BACK_L("armBackL", 3, 2, AttachmentPoint.ARM_BACK),
        ARM_BACK_R("armBackR", 6, 2, AttachmentPoint.ARM_BACK),
        ARM_SIDE_L("armSideL", 4, 2, AttachmentPoint.ARM_SIDE),
        ARM_SIDE_R("armSideR", 5, 2, AttachmentPoint.ARM_SIDE),
        LEG_SIDE_L("legSideL", 0, 1, AttachmentPoint.LEG_SIDE),
        LEG_SIDE_R("legSideR", 1, 1, AttachmentPoint.LEG_SIDE),
        BOOT_BACK_L("bootBackL", 0, 0, AttachmentPoint.BOOT_BACK),
        BOOT_BACK_R("bootBackR", 1, 0, AttachmentPoint.BOOT_BACK);

        public final int slot;
        public final int armorPiece;
        public final AttachmentPoint point;
        public final String id;

        private AttachmentLocation(String id, int slot, int armorPiece, AttachmentPoint point) {
            this.id = id;
            this.slot = slot;
            this.armorPiece = armorPiece;
            this.point = point;
        }
    }
}

