/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.powersuit;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.signalindustries.interfaces.IPowerSuit;
import sunsetsatellite.signalindustries.items.attachments.ItemAttachment;
import sunsetsatellite.signalindustries.powersuit.InventoryPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;

public class SignalumPowerSuitRemote
implements IPowerSuit {
    public InventoryPowerSuit helmet;
    public InventoryPowerSuit chestplate;
    public InventoryPowerSuit leggings;
    public InventoryPowerSuit boots;
    public PlayerRemote player;

    public SignalumPowerSuitRemote(PlayerRemote player) {
        this.player = player;
        this.reload();
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public int getMaxEnergy() {
        return 0;
    }

    @Override
    public float getEnergyPercent() {
        return 0.0f;
    }

    @Override
    public void decrementEnergy(int amount) {
    }

    @Override
    public void tick() {
    }

    @Override
    public InventoryPowerSuit getArmorPiece(int i) {
        switch (i) {
            case 3: {
                return this.helmet;
            }
            case 2: {
                return this.chestplate;
            }
            case 1: {
                return this.leggings;
            }
            case 0: {
                return this.boots;
            }
        }
        return null;
    }

    @Override
    public boolean hasAttachment(ItemAttachment attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !content.getItem().equals(attachment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAttachmentClass(Class<? extends ItemAttachment> attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !attachment.isInstance(content.getItem())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAttachment(ItemAttachment attachment, List<SignalumPowerSuit.AttachmentLocation> locations) {
        for (SignalumPowerSuit.AttachmentLocation location : locations) {
            InventoryPowerSuit armorPieceInv = this.getArmorPiece(location.armorPiece);
            ItemStack armorPieceAttachment = armorPieceInv.getItem(location.slot);
            if (armorPieceAttachment == null || !armorPieceAttachment.getItem().equals(attachment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getAttachment(ItemAttachment attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !content.getItem().equals(attachment)) continue;
                return content;
            }
        }
        return null;
    }

    @Override
    public ItemStack getAttachmentClass(Class<? extends ItemAttachment> attachment) {
        InventoryPowerSuit[] pieces;
        for (InventoryPowerSuit piece : pieces = new InventoryPowerSuit[]{this.helmet, this.chestplate, this.leggings, this.boots}) {
            for (ItemStack content : piece.contents) {
                if (content == null || !attachment.isInstance(content.getItem())) continue;
                return content;
            }
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    public void reload() {
        this.helmet = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(3));
        this.chestplate = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(2));
        this.leggings = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(1));
        this.boots = new InventoryPowerSuit(this.player.inventory.armorItemInSlot(0));
    }

    @Override
    public void loadData(CompoundTag suitTag) {
        if (suitTag.containsKey("Helmet") && suitTag.containsKey("Chestplate") && suitTag.containsKey("Leggings") && suitTag.containsKey("Boots")) {
            CompoundTag helmetTag = suitTag.getCompound("Helmet");
            CompoundTag chestplateTag = suitTag.getCompound("Chestplate");
            CompoundTag leggingsTag = suitTag.getCompound("Leggings");
            CompoundTag bootsTag = suitTag.getCompound("Boots");
            this.helmet.container.readFromNBT(helmetTag);
            this.chestplate.container.readFromNBT(chestplateTag);
            this.leggings.container.readFromNBT(leggingsTag);
            this.boots.container.readFromNBT(bootsTag);
            this.reload();
        }
    }

    @Override
    public void saveData(CompoundTag powerSuit) {
    }
}

