/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.util.MeteorLocation;

public class DynamicTextureMeteorTracker
extends DynamicTexture {
    private Minecraft mc;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;

    public DynamicTextureMeteorTracker(Minecraft minecraft, IconCoordinate iconCoordinate) {
        super(iconCoordinate);
        this.mc = minecraft;
    }

    public void postInit() {
        this.initTexture();
        BufferedImage atlas = this.targetTexture.parentAtlas.atlas;
        this.compassImageData = new byte[this.targetTexture.getArea() * 4];
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.targetTexture.height; ++y) {
                DynamicTextureMeteorTracker.putPixel((byte[])this.compassImageData, (int)(y * this.targetTexture.width + x), (int)atlas.getRGB(this.targetTexture.iconX + x, this.targetTexture.iconY + y));
            }
        }
        this.scaleFactor = (double)this.targetTexture.width / 16.0;
    }

    public boolean runUpdates(boolean isPaused) {
        return !isPaused;
    }

    public void update() {
        int a;
        int b;
        int g;
        int r;
        int j;
        int y2;
        int x2;
        int i;
        double angleSmooth;
        for (int _x = 0; _x < this.targetTexture.width; ++_x) {
            for (int _y = 0; _y < this.targetTexture.height; ++_y) {
                int i2 = _y * this.targetTexture.width + _x;
                int a2 = this.compassImageData[i2 * 4 + 3] & 0xFF;
                int r2 = this.compassImageData[i2 * 4 + 0] & 0xFF;
                int g2 = this.compassImageData[i2 * 4 + 1] & 0xFF;
                int b2 = this.compassImageData[i2 * 4 + 2] & 0xFF;
                this.imageData[i2 * 4 + 0] = (byte)r2;
                this.imageData[i2 * 4 + 1] = (byte)g2;
                this.imageData[i2 * 4 + 2] = (byte)b2;
                this.imageData[i2 * 4 + 3] = (byte)a2;
            }
        }
        double angle = 0.0;
        if (this.mc.currentWorld != null && this.mc.thePlayer != null) {
            Vec3i chunk = null;
            double distance = Double.MAX_VALUE;
            for (MeteorLocation meteorLocation : SignalIndustries.meteorLocations) {
                Vec3i location = meteorLocation.location;
                if (!(location.getSqDistanceTo((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y, (int)this.mc.thePlayer.z) < distance)) continue;
                distance = location.getSqDistanceTo((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y, (int)this.mc.thePlayer.z);
                chunk = location;
            }
            if (chunk != null) {
                double var23 = (double)chunk.x - this.mc.thePlayer.x;
                double var25 = (double)chunk.z - this.mc.thePlayer.z;
                angle = (double)(this.mc.thePlayer.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(var25, var23);
            } else {
                return;
            }
        }
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        double xs = (double)this.targetTexture.width / 2.0 + 0.5;
        double ys = (double)this.targetTexture.height / 2.0 - 0.5;
        for (i = (int)(-4.0 * this.scaleFactor); i <= (int)(4.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + y * (double)i * 0.3);
            y2 = (int)(ys - x * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
        for (i = (int)(-8.0 * this.scaleFactor); i <= (int)(16.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + x * (double)i * 0.3);
            y2 = (int)(ys + y * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            r = i >= 0 ? 255 : 100;
            g = i >= 0 ? 20 : 100;
            b = i >= 0 ? 20 : 100;
            a = 255;
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }
}

