/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.signalindustries.items.ItemBlueprint;
import sunsetsatellite.signalindustries.menus.MenuBuilder;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageBuilderConfig;
import sunsetsatellite.signalindustries.render.FakeItemElement;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBuilder;
import sunsetsatellite.signalindustries.util.SIMultiblock;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenBuilder
extends ScreenFluid {
    public Player player;
    public TileEntityBuilder tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;

    public ScreenBuilder(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuBuilder(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityBuilder)tile;
        this.player = inv.player;
        this.ySize = 247;
    }

    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        FakeItemElement guiRenderFakeItem = new FakeItemElement(this.mc);
        if (this.tile.itemContents[0] != null && this.tile.itemContents[0].getItem() instanceof ItemBlueprint) {
            String key = this.tile.itemContents[0].getData().getStringOrDefault("multiblock", "");
            if (Objects.equals(key, "")) {
                return;
            }
            SIMultiblock multiblock = (SIMultiblock)((Object)Multiblock.multiblocks.get(key.replace("multiblock.signalindustries.", "")));
            if (multiblock == null) {
                return;
            }
            List blocksUncondensed = this.tile.buildingBlocks.stream().map(B -> new ItemStack(B.block, 1, B.meta == -1 ? 0 : B.meta)).collect(Collectors.toList());
            ArrayList blocks = Catalyst.condenseItemList(blocksUncondensed);
            for (int k = 1; k < Math.min(this.tile.getContainerSize() + 1, blocks.size() + 1); ++k) {
                Slot slot = this.inventorySlots.getSlot(k);
                if (slot == null || slot.getItemStack() != null) continue;
                guiRenderFakeItem.render((ItemStack)blocks.get(k - 1), i + slot.x, j + slot.y, false, null, true);
            }
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_builder_gui.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            int counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 153, y + 18 + 12 - counter, 176, 28 - counter, 14, counter + 2);
        }
        if (this.tile.speedMultiplier > 1.0f) {
            this.drawStringCentered(this.font, this.tile.speedMultiplier + "x", x + this.xSize - 16, (int)((float)y + (float)this.ySize / 1.5f - 10.0f), this.tile.speedMultiplier >= 3.0f ? -23296 : (this.tile.speedMultiplier >= 2.0f ? -65281 : -32640));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
        this.font.drawCenteredString("Offset", 42, 12, -1);
        this.font.drawCenteredString("Rotation", 108, 35, -1);
        this.font.drawString(String.valueOf(this.tile.offset.x), 35, 30, -1, true);
        this.font.drawString(String.valueOf(this.tile.offset.y), 35, 55, -1, true);
        this.font.drawString(String.valueOf(this.tile.offset.z), 35, 80, -1, true);
        this.font.drawString(String.valueOf(this.tile.rotation.getName().charAt(0)), 105, 55, -1, true);
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 20, Math.round((float)this.height / 2.0f) - 47, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 40, Math.round((float)this.height / 2.0f) - 47, 20, 20, "I");
        this.buttons.add(itemIo);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f) + 63, Math.round((float)this.height / 2.0f) - 69, 20, 20, this.tile.workTimer.isPaused() ? "OFF" : "ON"));
        this.buttons.add(new ButtonElement(3, Math.round((float)this.width / 2.0f) - 75, Math.round((float)this.height / 2.0f) - 100, 20, 20, "+"));
        this.buttons.add(new ButtonElement(4, Math.round((float)this.width / 2.0f) - 35, Math.round((float)this.height / 2.0f) - 100, 20, 20, "-"));
        this.buttons.add(new ButtonElement(5, Math.round((float)this.width / 2.0f) - 75, Math.round((float)this.height / 2.0f) - 75, 20, 20, "+"));
        this.buttons.add(new ButtonElement(6, Math.round((float)this.width / 2.0f) - 35, Math.round((float)this.height / 2.0f) - 75, 20, 20, "-"));
        this.buttons.add(new ButtonElement(7, Math.round((float)this.width / 2.0f) - 75, Math.round((float)this.height / 2.0f) - 50, 20, 20, "+"));
        this.buttons.add(new ButtonElement(8, Math.round((float)this.width / 2.0f) - 35, Math.round((float)this.height / 2.0f) - 50, 20, 20, "-"));
        this.buttons.add(new ButtonElement(9, Math.round((float)this.width / 2.0f) - 10, Math.round((float)this.height / 2.0f) - 75, 20, 20, "<"));
        this.buttons.add(new ButtonElement(10, Math.round((float)this.width / 2.0f) + 30, Math.round((float)this.height / 2.0f) - 75, 20, 20, ">"));
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        }
        if (EnvironmentHelper.isClientWorld()) {
            switch (button.id) {
                case 2: {
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, !this.tile.workTimer.isPaused(), this.tile.getClass()));
                    button.displayString = this.tile.workTimer.isPaused() ? "OFF" : "ON";
                    break;
                }
                case 3: {
                    ++this.tile.offset.x;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 5: {
                    ++this.tile.offset.y;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 7: {
                    ++this.tile.offset.z;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 4: {
                    --this.tile.offset.x;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 6: {
                    --this.tile.offset.y;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 8: {
                    --this.tile.offset.z;
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 9: {
                    int i = this.tile.rotation.getSideNumber();
                    if (++i > 5) {
                        i = 2;
                    }
                    this.tile.rotation = Direction.getDirectionFromSide((int)i);
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
                case 10: {
                    int i = this.tile.rotation.getSideNumber();
                    if (--i < 2) {
                        i = 5;
                    }
                    this.tile.rotation = Direction.getDirectionFromSide((int)i);
                    this.tile.reset();
                    NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageBuilderConfig(this.tile.offset, this.tile.rotation, this.tile.workTimer.isPaused(), this.tile.getClass()));
                    break;
                }
            }
        } else {
            switch (button.id) {
                case 2: {
                    if (this.tile.workTimer.isPaused() && this.tile.fluidContents[0] != null && this.tile.itemContents[0] != null && this.tile.itemContents[0].getItem() instanceof ItemBlueprint) {
                        this.tile.workTimer.unpause();
                        this.tile.setStructureToBuild();
                        for (BlockInstance block : new ArrayList<BlockInstance>(this.tile.buildingBlocks)) {
                            if (this.tile.worldObj == null || !block.exists(this.tile.worldObj)) continue;
                            this.tile.buildingBlocks.remove(block);
                            ++this.tile.builtBlocks;
                        }
                        if (this.tile.buildingBlockIndex >= this.tile.buildingBlocks.size()) {
                            this.tile.buildingBlockIndex = 0;
                        }
                    } else {
                        this.tile.workTimer.pause();
                    }
                    button.displayString = this.tile.workTimer.isPaused() ? "OFF" : "ON";
                    break;
                }
                case 3: {
                    ++this.tile.offset.x;
                    this.tile.reset();
                    break;
                }
                case 5: {
                    ++this.tile.offset.y;
                    this.tile.reset();
                    break;
                }
                case 7: {
                    ++this.tile.offset.z;
                    this.tile.reset();
                    break;
                }
                case 4: {
                    --this.tile.offset.x;
                    this.tile.reset();
                    break;
                }
                case 6: {
                    --this.tile.offset.y;
                    this.tile.reset();
                    break;
                }
                case 8: {
                    --this.tile.offset.z;
                    this.tile.reset();
                    break;
                }
                case 9: {
                    int i = this.tile.rotation.getSideNumber();
                    if (++i > 5) {
                        i = 2;
                    }
                    this.tile.rotation = Direction.getDirectionFromSide((int)i);
                    this.tile.reset();
                    break;
                }
                case 10: {
                    int i = this.tile.rotation.getSideNumber();
                    if (--i < 2) {
                        i = 5;
                    }
                    this.tile.rotation = Direction.getDirectionFromSide((int)i);
                    this.tile.reset();
                    break;
                }
            }
        }
        super.buttonClicked(button);
    }
}

