/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.util.helper.Side;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuExternalIO;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageExternalIOLinkBreak;
import sunsetsatellite.signalindustries.screens.ScreenFluidIOConfig;
import sunsetsatellite.signalindustries.screens.ScreenItemIOConfig;
import sunsetsatellite.signalindustries.tiles.TileEntityExternalIO;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenExternalIO
extends ScreenFluid {
    public Player player;
    public TileEntityExternalIO tile;
    public ButtonElement itemIoButton;
    public ButtonElement fluidIoButton;
    public ButtonElement removeLinkButton;

    public ScreenExternalIO(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuExternalIO(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityExternalIO)tile;
        this.player = inv.player;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_gui_blank.png");
        switch (this.tile.tier) {
            case PROTOTYPE: 
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_gui_blank.png");
                break;
            }
            case REINFORCED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_gui_base.png");
                break;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
        int x = this.xSize / 2;
        int y = this.ySize / 4;
        if (this.tile.tier == Tier.REINFORCED) {
            if (this.tile.externalTilePos == null) {
                this.font.drawCenteredString("Disconnected.", x, y, -65536);
                this.font.drawCenteredString("No position.", x, y + 12, -65536);
            } else if (this.tile.externalTilePos.containsKey("x") && this.tile.externalTilePos.containsKey("y") && this.tile.externalTilePos.containsKey("z") && this.tile.externalTilePos.containsKey("dim") && this.tile.externalTilePos.containsKey("side")) {
                if (this.tile.externalTile != null) {
                    this.font.drawCenteredString("Connected!", x, y, -16711936);
                    this.font.drawCenteredString(this.tile.externalTile.getClass().getSimpleName().replace("TileEntity", "") + " @ " + this.tile.externalTile.x + " " + this.tile.externalTile.y + " " + this.tile.externalTile.z, x, y + 12, -16711936);
                    this.font.drawCenteredString(String.valueOf(Side.getSideById((int)this.tile.externalTilePos.getInteger("side"))), x, y + 24, -16711936);
                } else {
                    int eX = this.tile.externalTilePos.getInteger("x");
                    int eY = this.tile.externalTilePos.getInteger("y");
                    int eZ = this.tile.externalTilePos.getInteger("z");
                    int dim = this.tile.externalTilePos.getInteger("dim");
                    Vec3i pos = new Vec3i(eX, eY, eZ);
                    Vec3f selfPos = new Vec3f((double)this.tile.x, (double)this.tile.y, (double)this.tile.z);
                    if (this.tile.worldObj != null && dim != this.tile.worldObj.dimension.id) {
                        this.font.drawCenteredString("Can't connect.", x, y, -23296);
                        this.font.drawCenteredString("Outside this world.", x, y + 12, -23296);
                    } else if (pos.distanceTo(selfPos) > (double)TileEntityExternalIO.range) {
                        this.font.drawCenteredString("Can't connect.", x, y, -23296);
                        this.font.drawCenteredString("Out of reach.", x, y + 12, -23296);
                    }
                }
            }
        } else if (this.tile.externalTile != null) {
            this.font.drawCenteredString("Connected!", x, y, -16711936);
            this.font.drawCenteredString(this.tile.externalTile.getClass().getSimpleName().replace("TileEntity", "") + " @ " + this.tile.externalTileSide.getName(), x, y + 12, -16711936);
        } else {
            this.font.drawCenteredString("Disconnected.", x, y, -65536);
        }
    }

    public void init() {
        ButtonElement fluidIo = new ButtonElement(0, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 80, 20, 20, "F");
        this.buttons.add(fluidIo);
        ButtonElement itemIo = new ButtonElement(1, Math.round((float)this.width / 2.0f) + 60, Math.round((float)this.height / 2.0f) - 60, 20, 20, "I");
        this.buttons.add(itemIo);
        ButtonElement removeLink = new ButtonElement(2, Math.round((float)this.width / 2.0f) - 80, Math.round((float)this.height / 2.0f) - 80, 20, 20, "X");
        this.buttons.add(removeLink);
        this.fluidIoButton = fluidIo;
        this.itemIoButton = itemIo;
        this.removeLinkButton = removeLink;
        if (!(this.tile.externalTile instanceof Container)) {
            itemIo.enabled = false;
        }
        if (!(this.tile.externalTile instanceof IFluidInventory)) {
            fluidIo.enabled = false;
        }
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.itemIoButton) {
            this.mc.displayScreen((Screen)new ScreenItemIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.fluidIoButton) {
            this.mc.displayScreen((Screen)new ScreenFluidIOConfig((Player)this.mc.thePlayer, (MenuAbstract)this.fluidSlots, (Screen)this, this.tile));
        } else if (button == this.removeLinkButton) {
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageExternalIOLinkBreak(this.tile.getPosition(), this.tile.getClass()));
            }
            this.player.sendMessage("Link removed!");
            this.tile.externalTile = null;
            this.tile.externalTileSide = null;
            this.tile.externalTilePos = null;
        }
        super.buttonClicked(button);
    }
}

