/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.signalindustries.tiles.TileEntityMultiConduit;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenMultiConduitConfig
extends Screen {
    public Player entityplayer;
    public TileEntityMultiConduit tile;
    public int xSize = 176;
    public int ySize = 166;

    public ScreenMultiConduitConfig(ContainerInventory playerInv, TileEntity tile) {
        this.entityplayer = playerInv.player;
        this.tile = (TileEntityMultiConduit)tile;
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(partialTick);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.enableInventoryLight();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mx, my, partialTick);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    public void init() {
        this.buttons.add(new ButtonElement(2, this.width / 2 - 10, this.height / 2 - 63, 15, 15, "B"));
        this.buttons.add(new ButtonElement(4, this.width / 2 - 10, this.height / 2 - 48, 15, 15, "B"));
        this.buttons.add(new ButtonElement(3, this.width / 2 - 10, this.height / 2 - 33, 15, 15, "B"));
        this.buttons.add(new ButtonElement(0, this.width / 2 + 4, this.height / 2 - 48, 15, 15, "B"));
        this.buttons.add(new ButtonElement(1, this.width / 2 - 24, this.height / 2 - 48, 15, 15, "B"));
        this.buttons.add(new ButtonElement(5, this.width / 2 + 4, this.height / 2 - 33, 15, 15, "B"));
        this.buttons.add(new ButtonElement(8, this.width / 2 - 10 + 50, this.height / 2 - 63, 15, 15, this.tile.conduitConnections.get(Direction.Y_POS) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.Y_POS))));
        this.buttons.add(new ButtonElement(10, this.width / 2 - 10 + 50, this.height / 2 - 48, 15, 15, this.tile.conduitConnections.get(Direction.Z_POS) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.Z_POS))));
        this.buttons.add(new ButtonElement(9, this.width / 2 - 10 + 50, this.height / 2 - 33, 15, 15, this.tile.conduitConnections.get(Direction.Y_NEG) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.Y_NEG))));
        this.buttons.add(new ButtonElement(6, this.width / 2 + 4 + 50, this.height / 2 - 48, 15, 15, this.tile.conduitConnections.get(Direction.X_POS) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.X_POS))));
        this.buttons.add(new ButtonElement(7, this.width / 2 - 24 + 50, this.height / 2 - 48, 15, 15, this.tile.conduitConnections.get(Direction.X_NEG) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.X_NEG))));
        this.buttons.add(new ButtonElement(11, this.width / 2 + 4 + 50, this.height / 2 - 33, 15, 15, this.tile.conduitConnections.get(Direction.Z_NEG) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(Direction.Z_NEG))));
        ((ButtonElement)this.buttons.get((int)0)).enabled = false;
        ((ButtonElement)this.buttons.get((int)1)).enabled = false;
        ((ButtonElement)this.buttons.get((int)2)).enabled = false;
        ((ButtonElement)this.buttons.get((int)3)).enabled = false;
        ((ButtonElement)this.buttons.get((int)4)).enabled = false;
        ((ButtonElement)this.buttons.get((int)5)).enabled = false;
        if (Arrays.stream(this.tile.conduits).allMatch(Objects::isNull)) {
            ((ButtonElement)this.buttons.get((int)6)).enabled = false;
            ((ButtonElement)this.buttons.get((int)7)).enabled = false;
            ((ButtonElement)this.buttons.get((int)8)).enabled = false;
            ((ButtonElement)this.buttons.get((int)9)).enabled = false;
            ((ButtonElement)this.buttons.get((int)10)).enabled = false;
            ((ButtonElement)this.buttons.get((int)11)).enabled = false;
        }
        super.init();
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == 1) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (buttonNum == 1) {
            for (ButtonElement button : this.buttons) {
                if (!button.mouseClicked(this.mc, mx, my)) continue;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.buttonClickedAlt(button);
            }
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (this.tile != null) {
            if (button.id > 5 && button.id < 12) {
                Direction dir = Direction.values()[button.id - 6];
                Integer currentValue = this.tile.conduitConnections.get(dir);
                if (currentValue < this.tile.getAmountOfConduits() - 1) {
                    this.tile.conduitConnections.replace(dir, currentValue + 1);
                }
                button.displayString = String.valueOf(this.tile.conduitConnections.get(dir));
            }
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 0, this.tile.getPosition(), this.tile.getClass()));
            }
        }
        super.buttonClicked(button);
    }

    protected void buttonClickedAlt(ButtonElement button) {
        Direction dir;
        Integer currentValue;
        if (button.id > 5 && button.id < 12 && (currentValue = this.tile.conduitConnections.get(dir = Direction.values()[Math.min(6, Math.max(0, button.id - 6))])) > -1) {
            this.tile.conduitConnections.put(dir, currentValue - 1);
            String string = button.displayString = this.tile.conduitConnections.get(dir) == -1 ? "X" : String.valueOf(this.tile.conduitConnections.get(dir));
        }
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 1, 0, this.tile.getPosition(), this.tile.getClass()));
        }
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Multi Conduit", 45, 6, -12566464);
        this.font.drawString("I/O", 78, 70, -12566464);
        this.font.drawString("Conduit", 128, 70, -12566464);
        this.font.drawString("Y+", 26, 22, -1);
        this.font.drawString("Y-", 26, 58, -1);
        this.font.drawString("Z+", 26, 40, -1);
        this.font.drawString("X+", 44, 40, -1);
        this.font.drawString("Z-", 44, 58, -1);
        this.font.drawString("X-", 8, 40, -1);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/ioconfig.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }
}

