/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.menus.MenuMultiblock;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMultiblock;

public class ScreenMultiblock
extends ScreenFluid {
    public String name = "Unknown Multiblock";
    public Player player;
    public TileEntityTieredMultiblock tile;

    public ScreenMultiblock(ContainerInventory inventoryPlayer, TileEntity tile) {
        super((MenuFluid)new MenuMultiblock(inventoryPlayer, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityTieredMultiblock)tile;
        this.player = inventoryPlayer.player;
        this.name = ((TileEntityTieredMultiblock)tile).multiblock.data.getTranslatedName();
    }

    protected void drawGuiContainerBackgroundLayer(float f1) {
        int counter;
        Texture bgTex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/prototype_multiblock_gui.png");
        switch (this.tile.tier) {
            case PROTOTYPE: {
                bgTex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/prototype_multiblock_gui.png");
                break;
            }
            case BASIC: {
                bgTex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_multiblock_gui.png");
                break;
            }
            case REINFORCED: {
                bgTex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_multiblock_gui.png");
                break;
            }
            case AWAKENED: {
                bgTex = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/awakened_multiblock_gui.png");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bgTex);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        if (this.tile.isBurning()) {
            counter = this.tile.getBurnTimeRemainingScaled(12);
            this.drawTexturedModalRect(x + 56, y + 36 + 12 - counter, 176, 12 - counter, 14, counter + 2);
        }
        counter = this.tile.getProgressScaled(24);
        this.drawTexturedModalRect(x + 79, y + 34, 176, 14, counter + 1, 16);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawStringWithShadow(this.name, 10, 10, color);
        if (this.tile.isBurning()) {
            this.font.drawStringWithShadow("Current Parallel: " + TextFormatting.ORANGE + this.tile.parallel, 10, 20, -1);
        } else {
            this.font.drawStringWithShadow("Max Parallel: " + TextFormatting.ORANGE + this.tile.parallel, 10, 20, -1);
        }
        this.font.drawStringWithShadow("Speed Multiplier: " + TextFormatting.MAGENTA + this.tile.speedMultiplier + "x", 10, 30, -1);
        if (this.tile.isDisabled()) {
            this.font.drawStringWithShadow("Disabled", 10, 50, -65536);
        } else if (this.tile.isBurning()) {
            this.font.drawStringWithShadow(String.format("Processing: %d%%", this.tile.getProgressScaled(100)), 10, 50, -16711936);
        } else {
            this.font.drawStringWithShadow(TextFormatting.LIGHT_GRAY + "Idling..", 10, 50, -1);
        }
    }
}

